/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextField;

class AlignmentIndicator
extends JPanel {
    JTextField src;
    JTextField tgt;
    JTextField align;
    Vector markedMatches;
    int height;
    int width;
    private boolean debug;

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    AlignmentIndicator(JTextField jTextField, JTextField jTextField2, JTextField jTextField3, Vector vector) {
        this.src = jTextField;
        this.tgt = jTextField2;
        this.align = jTextField3;
        this.markedMatches = vector;
        this.debug = false;
        Dimension dimension = this.src.getPreferredSize();
        this.width = dimension.width;
        this.height = 75;
    }

    public void paint(Graphics graphics) {
        int n = 0;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.width, this.height);
        if (this.debug) {
            System.out.println("In Alignment Indicator paint");
        }
        if (this.align == null || this.src == null || this.tgt == null) {
            return;
        }
        String string = this.align.getText();
        if (!string.equals("()")) {
            int n2;
            int n3 = 0;
            int n4 = 1;
            while ((n4 = string.indexOf(40, n4)) != -1) {
                ++n4;
                ++n3;
            }
            Vector[] vectorArray = new Vector[n3 * 2];
            int n5 = string.length();
            int n6 = 2;
            int n7 = 2;
            int n8 = 0;
            for (int i = 0; i < n3 * 2; ++i) {
                vectorArray[i] = new Vector();
            }
            while (n6 < n5 - 1) {
                int n9;
                while (Character.isWhitespace(string.charAt(n6))) {
                    ++n6;
                }
                while (string.charAt(n6) != ',') {
                    n7 = n6;
                    while (Character.isDigit(string.charAt(n6))) {
                        ++n6;
                    }
                    n9 = n6;
                    vectorArray[n8].add(new Integer(string.substring(n7, n9)));
                    while (Character.isWhitespace(string.charAt(n6))) {
                        ++n6;
                    }
                }
                ++n8;
                ++n6;
                while (Character.isWhitespace(string.charAt(n6))) {
                    ++n6;
                }
                while (string.charAt(n6) != ')') {
                    n7 = n6;
                    while (Character.isDigit(string.charAt(n6))) {
                        ++n6;
                    }
                    n9 = n6;
                    vectorArray[n8].add(new Integer(string.substring(n7, n9)));
                    while (Character.isWhitespace(string.charAt(n6))) {
                        ++n6;
                    }
                }
                ++n8;
                ++n6;
                while (Character.isWhitespace(string.charAt(n6))) {
                    ++n6;
                }
                if (string.charAt(n6) == ',') {
                    ++n6;
                }
                while (n6 < n5 && Character.isWhitespace(string.charAt(n6))) {
                    ++n6;
                }
                if (n6 >= n5 || string.charAt(n6) != '(') continue;
                ++n6;
            }
            int[] nArray = new int[500];
            int[] nArray2 = new int[500];
            String string2 = this.src.getText();
            int n10 = string2.length();
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            for (n2 = 0; n2 < n10 && Character.isWhitespace(string2.charAt(n2)); ++n2) {
            }
            boolean bl = true;
            n13 = n2;
            while (n2 < n10) {
                if (!Character.isWhitespace(string2.charAt(n2)) && string2.charAt(n2) != '+' && bl) {
                    n14 = n2 + 1;
                } else if (!Character.isWhitespace(string2.charAt(n2)) && string2.charAt(n2) != '+' && !bl) {
                    bl = true;
                    n13 = n2;
                } else if ((Character.isWhitespace(string2.charAt(n2)) || string2.charAt(n2) == '+') && bl) {
                    bl = false;
                    nArray[(++n11 - 1) * 2] = n13;
                    nArray[(n11 - 1) * 2 + 1] = n14;
                }
                ++n2;
            }
            if (bl) {
                if (this.debug) {
                    System.out.println("last src word " + n13 + " " + n14);
                }
                nArray[n11 * 2] = n13;
                nArray[n11 * 2 + 1] = n14;
            }
            String string3 = this.tgt.getText();
            n10 = string3.length();
            n12 = 0;
            n13 = 0;
            n14 = 0;
            for (n2 = 0; n2 < n10 && Character.isWhitespace(string3.charAt(n2)); ++n2) {
            }
            bl = n2 < n10;
            n13 = n2;
            while (n2 < n10) {
                if (!Character.isWhitespace(string3.charAt(n2)) && string3.charAt(n2) != '+' && bl) {
                    n14 = n2 + 1;
                } else if (!Character.isWhitespace(string3.charAt(n2)) && string3.charAt(n2) != '+' && !bl) {
                    bl = true;
                    n13 = n2;
                } else if ((Character.isWhitespace(string3.charAt(n2)) || string3.charAt(n2) == '+') && bl) {
                    bl = false;
                    nArray2[(++n12 - 1) * 2] = n13;
                    nArray2[(n12 - 1) * 2 + 1] = n14;
                }
                ++n2;
            }
            if (bl) {
                if (this.debug) {
                    System.out.println("last tgt word " + n13 + " " + n14);
                }
                nArray2[(++n12 - 1) * 2] = n13;
                nArray2[(n12 - 1) * 2 + 1] = n14;
            }
            n = 0;
            if (n12 > 0) {
                for (n2 = 0; n2 < n10; ++n2) {
                    if (Character.UnicodeBlock.of(this.tgt.getText().charAt(n2)) != Character.UnicodeBlock.ARABIC && Character.UnicodeBlock.of(this.tgt.getText().charAt(n2)) != Character.UnicodeBlock.HEBREW) continue;
                    n = n2;
                }
            }
            for (n2 = 0; vectorArray != null && n2 < vectorArray.length; n2 += 2) {
                try {
                    Vector vector = vectorArray[n2];
                    Vector vector2 = vectorArray[n2 + 1];
                    if (vector.size() == 0 || vectorArray[n2 + 1].size() == 0) continue;
                    Integer n15 = (Integer)vector.firstElement();
                    Integer n16 = (Integer)vector.lastElement();
                    Integer n17 = (Integer)vector2.firstElement();
                    Integer n18 = (Integer)vector2.lastElement();
                    if (this.debug) {
                        System.out.println("Match pair " + n15 + " " + n17);
                    }
                    if (this.debug) {
                        System.out.println("Source offsets " + nArray[(n15 - 1) * 2] + " " + nArray[(n16 - 1) * 2 + 1]);
                    }
                    if (this.debug) {
                        System.out.println("Target offsets " + nArray2[(n17 - 1) * 2] + " " + nArray2[(n18 - 1) * 2 + 1]);
                    }
                    Rectangle rectangle = this.src.modelToView(nArray[(n15 - 1) * 2]);
                    Rectangle rectangle2 = this.src.modelToView(nArray[(n16 - 1) * 2 + 1]);
                    int n19 = rectangle.x + (rectangle2.x - rectangle.x) / 2;
                    if (this.debug) {
                        System.out.println("srcpos: " + nArray[(n15 - 1) * 2] + " " + nArray[(n16 - 1) * 2 + 1] + " " + rectangle + " " + rectangle2);
                    }
                    Rectangle rectangle3 = this.tgt.modelToView(nArray2[(n17 - 1) * 2]);
                    Rectangle rectangle4 = this.tgt.modelToView(nArray2[(n18 - 1) * 2 + 1]);
                    if (n + 1 == nArray2[(n18 - 1) * 2 + 1]) {
                        rectangle4.x = 3;
                    }
                    int n20 = rectangle3.x + (rectangle4.x - rectangle3.x) / 2;
                    if (this.debug) {
                        System.out.println("tgtpos: " + nArray2[(n17 - 1) * 2] + " " + nArray2[(n18 - 1) * 2 + 1] + " " + rectangle3 + " " + rectangle4);
                    }
                    if (this.debug) {
                        System.out.println("point pos " + n19 + " " + n20 + "\n");
                    }
                    graphics.setColor(Color.black);
                    if (vector.size() > 1 || vector2.size() > 1) {
                        graphics.setColor(Color.gray);
                    }
                    if (this.debug) {
                        System.out.println("Marked matches size " + this.markedMatches.size());
                    }
                    for (int i = 0; i < this.markedMatches.size(); i += 3) {
                        Integer n21 = (Integer)vectorArray[n2].firstElement();
                        Integer n22 = (Integer)vectorArray[n2 + 1].firstElement();
                        if (((Integer)this.markedMatches.elementAt(i)).intValue() != n21.intValue() || ((Integer)this.markedMatches.elementAt(i + 1)).intValue() != n22.intValue()) continue;
                        graphics.setColor((Color)this.markedMatches.elementAt(i + 2));
                        break;
                    }
                    graphics.drawLine(n19, 0, n20, this.height - 5);
                    if (vector.size() <= 1 && vector2.size() <= 1) continue;
                    graphics.drawLine(rectangle.x, 0, rectangle2.x, 0);
                    graphics.drawLine(rectangle3.x, this.height - 5, rectangle4.x, this.height - 5);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.debug) {
                System.out.println("");
            }
        }
    }
}

