package edu.cmu.cs.lti.letras.trees;

import java.util.ArrayList;

public class TreeNode<T> {

	private final ArrayList<TreeNode<T>> children = new ArrayList<TreeNode<T>>();
	private final ArrayList<T> values = new ArrayList<T>();

	public void addChild(TreeNode<T> child) {
		children.add(child);
	}

	public void addValue(T value) {
		this.values.add(value);
	}

	public ArrayList<T> getValues() {
		return values;
	}

	public String getValuesAsString() {
		StringBuilder builder = new StringBuilder();
		for (T value : values)
			builder.append(value.toString() + " ");
		if (builder.length() > 0)
			builder.deleteCharAt(builder.length() - 1);
		return builder.toString();
	}

	public final boolean isTerminal() {
		return (children.size() == 0);
	}

	public String toString() {
		if (isTerminal()) {
			return "(" + getValuesAsString() + ")";
		} else {

			StringBuilder childString = new StringBuilder();
			for (TreeNode<T> child : children) {
				childString.append(child.toString());
			}

			return "(" + getValuesAsString() + childString.toString() + ")";
		}
	}
}
