package edu.cmu.cs.lti.letras.trees;

import info.jonclark.util.StringUtils;

public class SmartTree<T> {

	private final TreeNode<T> root;

	public SmartTree(TreeNode<T> root) {
		this.root = root;
	}

	private static int findMatchingParen(String str, int start) {

		assert str.charAt(start) == '(';
		int nUnclosed = 1;
		for (int i = start + 1; i < str.length(); i++) {

			char c = str.charAt(i);
			if (c == '(')
				nUnclosed++;
			else if (c == ')')
				nUnclosed--;

			if (nUnclosed == 0)
				return i;
		}

		return -1;
	}

	public static <X> SmartTree<X> parse(String strTree) {

		// TODO: Handle input not starting with a paren
		// TODO: Handle input containing multiple root nodes

		assert strTree.charAt(0) == '(';
		assert strTree.charAt(strTree.length() - 1) == ')';

		TreeNode<X> root = parseRecursively(strTree.substring(1, strTree.length() - 1));
		return new SmartTree<X>(root);
	}

	private static <X> TreeNode<X> parseRecursively(String currentNode) {

		System.out.println("parsing: " + currentNode);

		TreeNode<X> treeNode = new TreeNode<X>();

		int nChildStart;
		int nChildEnd = -1;
		while ((nChildStart = currentNode.indexOf('(', nChildEnd)) != -1) {

			if (nChildStart != nChildEnd + 1) {
				String values = currentNode.substring(nChildEnd + 1, nChildStart);
				for (String value : StringUtils.tokenize(values)) {
					treeNode.addValue((X) value);

					System.out.println("Added value: " + value);
				}
			}

			nChildEnd = findMatchingParen(currentNode, nChildStart);
			assert nChildEnd != -1;
			assert nChildEnd < currentNode.length() - 1;

			String nestedNode = currentNode.substring(nChildStart + 1, nChildEnd);
			TreeNode<X> child = parseRecursively(nestedNode);
			treeNode.addChild(child);
		}

		if (nChildEnd + 1 < currentNode.length()) {
			String remainingValues = currentNode.substring(nChildEnd + 1, currentNode.length());
			System.out.println("remaining: " + remainingValues);
			for (String value : StringUtils.tokenize(remainingValues)) {
				treeNode.addValue((X) value);

				System.out.println("Added value: " + value);
			}
		}

		return treeNode;
	}

	public String toString() {
		return root.toString();
	}

	public static void main(String[] args) throws Exception {
		SmartTree<String> tree = parse("( (agent ((feature value) (another-feature 2))))");
		System.out.println(tree.toString());
	}
}
