/**
 * The LETRAS Project
 * Language Technologies Institute
 * School of Computer Science
 * (c) 2007 Carnegie Mellon University
 */
package edu.cmu.cs.lti.letras.filtering;

import java.util.ArrayList;

import edu.cmu.cs.lti.letras.corpus.SentenceTest;
import edu.cmu.cs.lti.letras.features.FeatureGroup;
import edu.cmu.cs.lti.letras.features.FeatureGroupSet;

/**
 * Filters out SentenceTests that are no longer relevant based on the features
 * they are testing for and the features we already hypothesize to be true for
 * this language.
 */
public class TestFilter {

	private final FeatureGroupSet<SentenceTest> testSet = new FeatureGroupSet<SentenceTest>();

	public TestFilter(ArrayList<FeatureGroup<SentenceTest>> tests) {
		for (FeatureGroup<SentenceTest> pair : tests) {
			testSet.add(pair);
		}
	}

	/**
	 * @param <X>
	 *            Ignored.
	 * @param unknownFeatures
	 * @return
	 */
	public <X> ArrayList<SentenceTest> getRemainingTests(FeatureGroup<X> unknownFeatures) {

		// a test becomes irrelevant when it can no longer imply an unknown
		// language feature

		ArrayList<FeatureGroup<SentenceTest>> subsets = testSet.getSubsetsOf(unknownFeatures);
		ArrayList<SentenceTest> filteredSentences = new ArrayList<SentenceTest>(subsets.size());

		for (FeatureGroup<SentenceTest> subset : subsets) {
			filteredSentences.add(subset.getValue());
		}

		return filteredSentences;
	}
}
