/**
 * The LETRAS Project
 * Language Technologies Institute
 * School of Computer Science
 * (c) 2007 Carnegie Mellon University
 */
package edu.cmu.cs.lti.letras.filtering;

import java.util.ArrayList;
import java.util.HashSet;

import edu.cmu.cs.lti.letras.corpus.SentencePair;
import edu.cmu.cs.lti.letras.corpus.SentencePairFactory;
import edu.cmu.cs.lti.letras.corpus.SentenceTest;
import edu.cmu.cs.lti.letras.features.Feature;
import edu.cmu.cs.lti.letras.features.FeatureGroup;

public class SentenceAnalyzer {

	private final ArrayList<FeatureGroup<SentenceTest>> tests;
	private final HashSet<Integer> elicitedSentencePairs = new HashSet<Integer>();

	public SentenceAnalyzer(ArrayList<FeatureGroup<SentenceTest>> tests) {
		this.tests = tests;
	}
	
	private boolean haveEliciatedAllRequiredSentences(int[] requiredSentences) {
		for(int i : requiredSentences) {
			if(!elicitedSentencePairs.contains(i))
				return false;
		}
		return true;
	}

	public ArrayList<Feature> getDiscoveredFeatures() {
		// TODO: Analyze modification on element-by-element basis
		// TODO: only run tests that have not fired yet -- WHAT ABOUT
		// MODIFICATION OF SENTENCES!!!

		ArrayList<Feature> discoveredFeatures = new ArrayList<Feature>();

		for (FeatureGroup<SentenceTest> testWrapper : tests) {
			SentenceTest test = testWrapper.getValue();
			int[] requiredPairs = test.getRequiredPairs();
			if (haveEliciatedAllRequiredSentences(requiredPairs)) {

				assert requiredPairs.length > 1 : "There must be at least 2 required pairs";

				boolean allEqual = true;
				boolean noneEqual = true;
				SentencePair pairA = SentencePairFactory.getById(requiredPairs[0]);
				for (int i = 1; i < requiredPairs.length; i++) {
					SentencePair pairB = SentencePairFactory.getById(requiredPairs[i]);
					if (pairA.hasEqualTranslation(pairB)) {
						noneEqual = false;
					}
					if (!pairA.hasEqualTranslation(pairB)) {
						allEqual = false;
					}
				}

				if (allEqual) {
					discoveredFeatures.addAll(test.getEqualityImplications());
				} else if (noneEqual) {
					discoveredFeatures.addAll(test.getInequalityImplications());
				} else {
					assert false : "Either all or none should be equal under current assumptions";
				}
			}
		}

		return discoveredFeatures;
	}

	public void addElicitedSentencePair(SentencePair pair) {
		elicitedSentencePairs.add(pair.getId());
	}
}
