/**
 * The LETRAS Project
 * Language Technologies Institute
 * School of Computer Science
 * (c) 2007 Carnegie Mellon University
 */
package edu.cmu.cs.lti.letras.features;

import java.util.ArrayList;
import java.util.Random;

public class Feature {
	
	private final String name;
	protected final int maskArrayIndex;
	protected final long maskBits;



	/**
	 * Require instantiation through static method so that we get a 1-to-1
	 * mapping between feature names and their uniquemasks.
	 */
	protected Feature(String name, int maskArrayIndex, long maskBits) {
		this.name = name;
		this.maskArrayIndex = maskArrayIndex;
		this.maskBits = maskBits;
	}

	

	public String getName() {
		return name;
	}

	public boolean equals(Object obj) {
		if(this == obj) {
			return true;
		} else if (obj instanceof Feature) {
			Feature other = (Feature) obj;
			return (this.maskArrayIndex == other.maskArrayIndex)
					&& (this.maskBits == other.maskBits);
		} else {
			return false;
		}
	}

	public int hashCode() {
		// TODO: Determine if this is a logical hash
		return (int) maskBits ^ 31;
	}

	public String toString() {
		return name;
	}

	public static void main(String[] args) throws Exception {
		Feature hi = FeatureFactory.getInstance("hi");
		Feature hello = FeatureFactory.getInstance("hello");

		System.out.println("hi = " + Long.toBinaryString(hi.maskBits));
		System.out.println("hello = " + Long.toBinaryString(hello.maskBits));

		ArrayList<Feature> list = new ArrayList<Feature>();
		list.add(hi);
		FeatureGroup<String> gHi = new FeatureGroup<String>(list, null);
		System.out.println("gHi = " + Long.toBinaryString(gHi.compositeMask[0]));
		list.clear();
		list.add(hello);
		FeatureGroup<String> gHello = new FeatureGroup<String>(list, null);
		System.out.println("gHello = " + Long.toBinaryString(gHello.compositeMask[0]));
		list.add(hi);
		FeatureGroup<String> gAll = new FeatureGroup<String>(list, null);
		System.out.println("gAll = " + Long.toBinaryString(gAll.compositeMask[0]));

		System.out.println(gAll.isSubsetOf(gHello));

		// TODO: Write large test set and expected values in a JUnit test.

		FeatureGroupSet<String> smallSet = new FeatureGroupSet<String>();
		smallSet.add(gHi);
		smallSet.add(gHello);
		smallSet.add(gAll);
		for (FeatureGroup<String> fg : smallSet.getSubsetsOf(gAll)) {
			System.out.println(fg);
		}

		System.out.println("-------------------");

//		SecondTimer timer = new SecondTimer();
//		timer.go();

		int NUM_FEATURES = 1000;
		Feature[] features = new Feature[NUM_FEATURES];
		for (int i = 0; i < NUM_FEATURES; i++) {
			features[i] = FeatureFactory.getInstance("f" + i);
		}

		int NUM_GROUPS = 10000;
		int MAX_PER_SET = 50;
		Random rand = new Random();
		FeatureGroup[] featureGroups = new FeatureGroup[NUM_GROUPS];
		FeatureGroupSet bigSet = new FeatureGroupSet();
		for (int i = 0; i < NUM_GROUPS; i++) {
			list.clear();

			// add a random number of features to this group
			for (int j = 0; j < rand.nextInt(MAX_PER_SET); j++) {
				list.add(features[rand.nextInt(NUM_FEATURES)]);
			}

			featureGroups[i] = new FeatureGroup<String>(list, null);
			bigSet.add(featureGroups[i]);
		}

//		timer.pause();
//		System.out.println("built in " + timer.getSecondsFormatted() + " seconds");
//		timer.reset();
//		timer.go();

		for (int i = 0; i < NUM_GROUPS; i++) {
			ArrayList<FeatureGroup> subsets = bigSet.getSubsetsOf(featureGroups[i]);
//			System.out.println(subsets.toString() + " are subsets of "
//					+ featureGroups[i].toString());
		}

//		timer.pause();
//		System.out.println("searched in " + timer.getSecondsFormatted() + " seconds");
	}

}
