package edu.cmu.cs.lti.letras.features;

import java.util.Arrays;
import java.util.HashMap;

public class FeatureFactory {

	private static final HashMap<String, Feature> featuresByString = new HashMap<String, Feature>();
	private static final HashMap<FeatureKey, Feature> featuresByMask = new HashMap<FeatureKey, Feature>();
	private static int nextBitPosition = 0;

	/**
	 * Wrapper for the primitive long array that generates a proper hashcode.
	 */
	private static class FeatureKey {
		public final int maskArrayIndex;
		public final long maskBits;
		public final int hashCode;

		public FeatureKey(int maskArrayIndex, long maskBits) {
			this.maskArrayIndex = maskArrayIndex;
			this.maskBits = maskBits;

			// this.hashCode = (int) maskBits;
			this.hashCode = Arrays.hashCode(new long[] { maskArrayIndex, maskBits });
		}

		public int hashCode() {
			return hashCode;
		}

		public boolean equals(Object obj) {
			if (obj instanceof FeatureKey) {
				FeatureKey other = (FeatureKey) obj;
				return (this.maskArrayIndex == other.maskArrayIndex)
						&& (this.maskBits == other.maskBits);
			} else {
				return false;
			}
		}
	}

	public static Feature getInstance(String name) {
		Feature feature = featuresByString.get(name);
		if (feature == null) {

			int maskArrayIndex = nextBitPosition / Long.SIZE;
			long maskBits = 1L << (nextBitPosition % Long.SIZE);

			feature = new Feature(name, maskArrayIndex, maskBits);
			featuresByString.put(name, feature);
			featuresByMask.put(new FeatureKey(maskArrayIndex, maskBits), feature);

			// System.err.println("Adding " + maskBits + " @ " +
			// maskArrayIndex);

			nextBitPosition++;
		}
		return feature;
	}

	public static Feature getFeatureByMask(int maskArrayIndex, long maskBits) {
		FeatureKey key = new FeatureKey(maskArrayIndex, maskBits);
		return featuresByMask.get(key);
	}

	/**
	 * The maximum number of bits required to represent any of the current
	 * features.
	 * 
	 * @return
	 */
	public static int getCurrentBitCount() {
		return nextBitPosition;
	}
}
