package edu.cmu.cs.lti.letras.corpus;

/**
 * Represents a single sentence pair that either will or has been presented to
 * the user during elicitation.
 */
public class SentencePair implements Comparable<SentencePair> {

	private final int id;
	private String[] eSentence;
	private String[] fSentence;
	private String alignments;
	private String context;
	private String comment;

	protected SentencePair(int id, String[] sentence, String[] sentence2, String alignments,
			String context, String comment) {

		assert id != -1;
		assert sentence != null;
		assert sentence2 != null;
		assert alignments != null;
		assert context != null;
		assert comment != null;

		this.id = id;
		eSentence = sentence;
		fSentence = sentence2;
		this.alignments = alignments;
		this.context = context;
		this.comment = comment;
	}

	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		else if (obj instanceof SentencePair) {
			SentencePair other = (SentencePair) obj;
			return (this.id == other.id);
		} else {
			return false;
		}
	}

	public int hashCode() {
		return id;
	}

	public boolean hasEqualTranslation(SentencePair other) {
		if (this.fSentence.length != other.fSentence.length) {
			return false;
		} else {
			for (int i = 0; i < fSentence.length; i++) {
				if (!this.fSentence[i].equals(other.fSentence[i]))
					return false;
			}

			return true;
		}
	}

	public String[] getESentence() {
		return eSentence;
	}

	public void setESentence(String[] sentence) {
		eSentence = sentence;
	}

	public String[] getFSentence() {
		return fSentence;
	}

	public void setFSentence(String[] sentence) {
		fSentence = sentence;
	}

	public String getAlignments() {
		return alignments;
	}

	public void setAlignments(String alignments) {
		this.alignments = alignments;
	}

	public String getContext() {
		return context;
	}

	public void setContext(String context) {
		this.context = context;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public int getId() {
		return id;
	}

	@Override
	public int compareTo(SentencePair other) {
		return this.id - other.id;
	}
}
