/*
 * Decompiled with CFR 0.152.
 */
package com.linearb.util.sentence;

import com.linearb.util.sentence.Grid;
import java.util.Arrays;

public class MaskedGrid
extends Grid {
    protected int xOffset;
    protected int yOffset;

    public MaskedGrid(Grid fullGrid, int xOffset, int width, int yOffset, int height) {
        super(width, height);
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        if (xOffset + width > fullGrid.getWidth() || yOffset + height > fullGrid.getHeight()) {
            throw new ArrayIndexOutOfBoundsException("invalid parent grid: " + this.getXOffset() + " " + this.getWidth() + " " + fullGrid.getWidth() + " " + this.getYOffset() + " " + this.getHeight() + " " + fullGrid.getHeight());
        }
        this.coordinates = fullGrid.coordinates;
        this.transposedCoordinates = fullGrid.transposedCoordinates;
        this.transposed = fullGrid.transposed;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().isInstance(this)) {
            return false;
        }
        MaskedGrid other = (MaskedGrid)o;
        return this.getWidth() == other.getWidth() && this.getHeight() == other.getHeight() && Arrays.equals(this.getCoordinates(), other.getCoordinates());
    }

    public int[] getRowPoints(int columnStart, int columnEnd) {
        int[] points = super.getRowPoints(columnStart, columnEnd);
        return this.offsetPoints(points, this.getYOffset());
    }

    public int[] getColumnPoints(int rowStart, int rowEnd) {
        int[] points = super.getColumnPoints(rowStart, rowEnd);
        return this.offsetPoints(points, this.getXOffset());
    }

    public int[] offsetPoints(int[] points, int offset) {
        int numPoints = 0;
        for (int i = 0; i < points.length; ++i) {
            if (points[i] < offset) continue;
            ++numPoints;
        }
        int[] offsetPoints = new int[numPoints];
        int index = 0;
        for (int i = 0; i < points.length; ++i) {
            if (points[i] < offset) continue;
            offsetPoints[index++] = points[i] - offset;
        }
        return offsetPoints;
    }

    protected int getXOffset() {
        if (!this.transposed) {
            return this.xOffset;
        }
        return this.yOffset;
    }

    protected int getYOffset() {
        if (!this.transposed) {
            return this.yOffset;
        }
        return this.xOffset;
    }

    protected short getKey(int x, int y) {
        int storedX = x + this.getXOffset();
        int storedY = y + this.getYOffset();
        return super.getKey(storedX, storedY);
    }

    protected short[] getLocation(short key) {
        short[] location = super.getLocation(key);
        location[0] = (short)(location[0] - this.getXOffset());
        location[1] = (short)(location[1] - this.getYOffset());
        if (this.isValid(location[0], location[1])) {
            return location;
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

