/*
 * Decompiled with CFR 0.152.
 */
package com.linearb.util.sentence;

public class Coordinate
implements Comparable {
    public int x;
    public int y;

    public Coordinate(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Coordinate(Coordinate c) {
        this.x = c.x;
        this.y = c.y;
    }

    public void transpose() {
        int oldX = this.x;
        this.x = this.y;
        this.y = oldX;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().isInstance(this)) {
            return false;
        }
        Coordinate other = (Coordinate)o;
        return other.x == this.x && other.y == this.y;
    }

    public int hashCode() {
        if (this.x <= this.y) {
            return this.x * 100 + this.y;
        }
        return this.y * 100 + this.x;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public int compareTo(Object o) throws ClassCastException {
        Coordinate location = (Coordinate)o;
        if (this.x < location.x) {
            return -1;
        }
        if (this.x > location.x) {
            return 1;
        }
        if (this.y < location.y) {
            return -1;
        }
        if (this.y > location.y) {
            return 1;
        }
        return 0;
    }

    public boolean sameColumn(Coordinate other) {
        return this.x == other.x;
    }

    public boolean sameRow(Coordinate other) {
        return this.y == other.y;
    }

    public static Coordinate toCoordinate(String coordinate) {
        int divider = coordinate.indexOf(46);
        int x = Integer.parseInt(coordinate.substring(0, divider));
        int y = Integer.parseInt(coordinate.substring(divider + 1));
        return new Coordinate(x, y);
    }
}

