/*
 * Decompiled with CFR 0.152.
 */
package com.linearb.util.sentence;

import com.linearb.util.sentence.Grid;
import com.linearb.util.sentence.Phrase;
import com.linearb.util.sentence.Vocabulary;
import java.util.Arrays;

public class Alignment {
    public static final int HASH_SEED = 17;
    public static final int HASH_OFFSET = 37;
    protected Phrase source;
    protected Phrase target;
    protected Grid grid;

    public Alignment(Phrase source, Phrase target, Grid grid) {
        this.source = source;
        this.target = target;
        this.grid = grid;
    }

    public Phrase getSource() {
        return this.source;
    }

    public Phrase getTarget() {
        return this.target;
    }

    public int getSourceLength() {
        return this.source.size();
    }

    public int getTargetLength() {
        return this.target.size();
    }

    public void setAlignmentPoints(Grid newAlignmentPoints) {
        this.grid = newAlignmentPoints;
    }

    public Grid getAlignmentPoints() {
        return this.grid;
    }

    public void transpose() {
        Phrase oldSource = this.source;
        this.source = this.target;
        this.target = oldSource;
        this.grid.transpose();
    }

    public Alignment expandTarget(Alignment expandedAlignment, int sourcePosition) {
        int targetLength = this.getTargetLength();
        this.target.append(expandedAlignment.getTarget());
        Phrase expandedTarget = this.target;
        this.target = expandedTarget.subPhrase(0, targetLength);
        expandedAlignment.target = expandedTarget.subPhrase(targetLength, expandedTarget.size());
        Grid expandedGrid = Grid.extend(this.source.size(), expandedTarget.size(), this.grid, 0, 0, expandedAlignment.grid, sourcePosition, targetLength);
        return new Alignment(this.source, expandedTarget, expandedGrid);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().isInstance(this)) {
            return false;
        }
        Alignment other = (Alignment)o;
        return this.source.equals(other.source) && this.target.equals(other.target);
    }

    public int hashCode() {
        int i;
        int result = 17;
        for (i = 0; i < this.source.size(); ++i) {
            result = 37 * result + this.source.getWord(i).getID();
        }
        for (i = 0; i < this.target.size(); ++i) {
            result = 37 * result + this.target.getWord(i).getID();
        }
        return result;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeGrid) {
        StringBuffer buf = new StringBuffer();
        buf.append("<\"");
        buf.append(this.source.toString());
        buf.append("\", \"");
        buf.append(this.target.toString());
        buf.append("\"");
        if (includeGrid) {
            buf.append(", ");
            buf.append(this.grid.toString());
        }
        buf.append(">");
        return buf.toString();
    }

    public String toAsciiGraph() {
        StringBuffer buffer = new StringBuffer();
        int longestTargetWord = 0;
        for (int i = 0; i < this.getTargetLength(); ++i) {
            longestTargetWord = Math.max(longestTargetWord, this.target.get(i).toString().length());
        }
        char[] space = new char[longestTargetWord];
        Arrays.fill(space, ' ');
        for (int i = 0; i < this.getSourceLength(); ++i) {
            buffer.append(space);
            for (int j = 0; j <= i; ++j) {
                buffer.append("  |");
            }
            buffer.append(this.source.get(i));
            buffer.append('\n');
        }
        buffer.append(space);
        buffer.append("  ");
        space = new char[this.getSourceLength() * 3 + 1];
        Arrays.fill(space, '-');
        buffer.append(space);
        buffer.append('\n');
        boolean[][] array = this.grid.generateBooleanArray();
        for (int row = 0; row < this.getTargetLength(); ++row) {
            String targetWord = this.target.get(row).toString();
            space = new char[longestTargetWord - targetWord.length()];
            Arrays.fill(space, ' ');
            buffer.append(space);
            buffer.append(targetWord);
            buffer.append("  |");
            for (int column = 0; column < this.getSourceLength(); ++column) {
                if (array[column][row]) {
                    buffer.append("XX");
                } else {
                    buffer.append("  ");
                }
                buffer.append("|");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static void main(String[] args) throws Exception {
        Vocabulary enVocab = new Vocabulary();
        Vocabulary deVocab = new Vocabulary();
        Phrase source = new Phrase("the minutes of yesterday ' s sitting have been distributed .", enVocab);
        Phrase target = new Phrase("das protokoll der letzten sitzung", deVocab);
        Grid grid = new Grid(source.size(), target.size(), "0.0,1.1,2.2,3.3,6.4");
        Alignment alignment = new Alignment(source, target, grid);
        System.out.println(alignment.toAsciiGraph());
        Phrase source2 = new Phrase("been distributed .", enVocab);
        Phrase target2 = new Phrase("wurde verteilt .", deVocab);
        Grid grid2 = new Grid(source.size(), target2.size(), "0.0,1.1,2.2");
        Alignment alignment2 = new Alignment(source2, target2, grid2);
        System.out.println(alignment2.toAsciiGraph());
        Alignment alignment3 = alignment.expandTarget(alignment2, 8);
        System.out.println(alignment3.toAsciiGraph());
        System.out.println(alignment.toAsciiGraph());
    }
}

