/*
 * Decompiled with CFR 0.152.
 */
package com.linearb.eval.annotation;

import com.linearb.eval.ProbableAlignment;
import com.linearb.util.sentence.Word;
import javax.swing.table.AbstractTableModel;

public class AlignmentTableModel
extends AbstractTableModel {
    private ProbableAlignment alignment;
    private boolean[][] array;

    public AlignmentTableModel(ProbableAlignment alignment) {
        this.alignment = alignment;
        this.array = alignment.getAlignmentPoints().generateBooleanArray();
    }

    public void showSource() {
        this.array = this.alignment.getAlignmentPoints().generateBooleanArray();
        this.fireTableDataChanged();
    }

    public void showTarget() {
        this.array = this.alignment.getAlignmentPoints().generateBooleanArray();
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return this.array.length + 1;
    }

    public int getRowCount() {
        return this.array[0].length;
    }

    public String getColumnName(int col) {
        if (col == 0) {
            return "";
        }
        Word word = this.alignment.getSource().getWord(col - 1);
        return word.toString();
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            Word word = this.alignment.getTarget().getWord(row);
            return word.toString();
        }
        if (this.array[col - 1][row]) {
            return "######";
        }
        return "";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return col >= 2;
    }
}

