/*
 * Decompiled with CFR 0.152.
 */
package com.linearb.eval;

import com.linearb.util.sentence.Phrase;
import com.linearb.util.sentence.Vocabulary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class ReferenceTranslations {
    private HashMap modifiedNGramCounts;
    private HashMap numberOfNGrams;
    private int maxNGram;
    private ArrayList lengths;

    public ReferenceTranslations(int maxNGram) {
        this.maxNGram = maxNGram;
        this.lengths = new ArrayList();
        this.modifiedNGramCounts = new HashMap();
    }

    public void addReference(Phrase referenceTranslation) {
        HashMap counts = ReferenceTranslations.getNGramCounts(referenceTranslation, this.maxNGram);
        Iterator it = counts.keySet().iterator();
        while (it.hasNext()) {
            Phrase phrase = (Phrase)it.next();
            Integer newCount = (Integer)counts.get(phrase);
            Integer currentCount = (Integer)this.modifiedNGramCounts.get(phrase);
            if (currentCount == null) {
                this.modifiedNGramCounts.put(phrase, newCount);
                continue;
            }
            if (newCount <= currentCount) continue;
            this.modifiedNGramCounts.put(phrase, newCount);
        }
        this.lengths.add(new Integer(referenceTranslation.size()));
        Collections.sort(this.lengths);
    }

    public HashMap calculateNGramPrecision(Phrase candidateTranslation) {
        HashMap numberOfMatchingNGrams = new HashMap();
        HashMap totalNGrams = new HashMap();
        this.collectNGramCounts(candidateTranslation, numberOfMatchingNGrams, totalNGrams);
        return ReferenceTranslations.calculateNGramPrecision(numberOfMatchingNGrams, totalNGrams, this.maxNGram);
    }

    public static HashMap calculateNGramPrecision(HashMap numberOfMatchingNGrams, HashMap totalNGrams, int n) {
        HashMap<Integer, Double> nGramPrecision = new HashMap<Integer, Double>();
        for (int i = 1; i <= n; ++i) {
            Integer phraseLength = new Integer(i);
            int numMatches = ReferenceTranslations.getCount(phraseLength, numberOfMatchingNGrams);
            int total = ReferenceTranslations.getCount(phraseLength, totalNGrams);
            double precision = 0.0;
            if (total > 0) {
                precision = (double)numMatches / (double)total;
            }
            nGramPrecision.put(phraseLength, new Double(precision));
        }
        return nGramPrecision;
    }

    public void collectNGramCounts(Phrase candidateTranslation, HashMap numberOfMatchingNGrams, HashMap totalNGrams) {
        HashMap candidateNGramCounts = ReferenceTranslations.getNGramCounts(candidateTranslation, this.maxNGram);
        Iterator it = candidateNGramCounts.keySet().iterator();
        while (it.hasNext()) {
            Phrase phrase = (Phrase)it.next();
            int candidateCount = ReferenceTranslations.getCount(phrase, candidateNGramCounts);
            int referenceCount = ReferenceTranslations.getCount(phrase, this.modifiedNGramCounts);
            Integer phraseLength = new Integer(phrase.size());
            ReferenceTranslations.incrementCount(phraseLength, numberOfMatchingNGrams, Math.min(candidateCount, referenceCount));
            ReferenceTranslations.incrementCount(phraseLength, totalNGrams, candidateCount);
        }
    }

    public int getBestMatchLength(Phrase candidateTranslation) {
        return this.getBestMatchLength(candidateTranslation.size());
    }

    public int getBestMatchLength(int candidateTranslationLength) {
        Integer length = new Integer(candidateTranslationLength);
        int indexOfMatch = Math.abs(Collections.binarySearch(this.lengths, length));
        if (indexOfMatch >= this.lengths.size()) {
            indexOfMatch = this.lengths.size() - 1;
        }
        return (Integer)this.lengths.get(indexOfMatch);
    }

    protected static HashMap getNGramCounts(Phrase sentence, int n) {
        HashMap nGramCounts = new HashMap();
        ArrayList subPhrases = sentence.getSubPhrases(n);
        Iterator it = subPhrases.iterator();
        while (it.hasNext()) {
            Phrase subPhrase = (Phrase)it.next();
            ReferenceTranslations.incrementCount(subPhrase, nGramCounts);
        }
        return nGramCounts;
    }

    protected static void incrementCount(Object obj, HashMap counts, int amount) {
        Integer count = (Integer)counts.get(obj);
        count = count == null ? new Integer(amount) : new Integer(count + amount);
        counts.put(obj, count);
    }

    protected static void incrementCount(Object obj, HashMap counts) {
        ReferenceTranslations.incrementCount(obj, counts, 1);
    }

    protected static int getCount(Object obj, HashMap counts) {
        Integer count = (Integer)counts.get(obj);
        if (count != null) {
            return count;
        }
        return 0;
    }

    public static void main(String[] args) {
        Vocabulary vocab = new Vocabulary();
        ReferenceTranslations referenceItem = new ReferenceTranslations(4);
        referenceItem.addReference(new Phrase("it is a guide to action that ensures that the military will forever heed party commands", vocab));
        referenceItem.addReference(new Phrase("it is the guiding principle which guarantees the military forces always being under the command of the party", vocab));
        referenceItem.addReference(new Phrase("it is the practical guide for the army always to heed the directions of the party", vocab));
        Phrase candidate1 = new Phrase("it is a guide to action which ensures that the military always obeys the commands of the party 1 2 3", vocab);
        Phrase candidate2 = new Phrase("it is to insure the troops forever hearing the activity guidebook that party direct", vocab);
        System.out.println("CANDIDATE 1:");
        System.out.println(referenceItem.calculateNGramPrecision(candidate1));
        System.out.println("Length " + candidate1.size() + ", Closest Length = " + referenceItem.getBestMatchLength(candidate1.size()));
        System.out.println("\nCANDIDATE 2:");
        System.out.println(referenceItem.calculateNGramPrecision(candidate2));
        System.out.println("Length " + candidate2.size() + ", Closest Length = " + referenceItem.getBestMatchLength(candidate2.size()));
    }
}

