/*
 * Decompiled with CFR 0.152.
 */
package com.linearb.eval;

import com.linearb.eval.ReferenceTranslations;
import com.linearb.util.FileUtil;
import com.linearb.util.sentence.Phrase;
import com.linearb.util.sentence.Vocabulary;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Bleu {
    private ArrayList referenceCorpus;
    private int maxNGram;
    private double[] nGramWeights;

    public Bleu(int maxNGram) {
        this.maxNGram = maxNGram;
        this.nGramWeights = new double[maxNGram];
        for (int i = 0; i < this.nGramWeights.length; ++i) {
            this.nGramWeights[i] = 1.0 / (double)maxNGram;
        }
    }

    public Bleu(int maxNGram, double[] nGramWeights) {
        this.maxNGram = maxNGram;
        this.nGramWeights = nGramWeights;
    }

    public void addReferenceTranslations(ArrayList translations) {
        int i;
        if (this.referenceCorpus == null) {
            this.referenceCorpus = new ArrayList();
            for (i = 0; i < translations.size(); ++i) {
                this.referenceCorpus.add(new ReferenceTranslations(this.maxNGram));
            }
        }
        for (i = 0; i < translations.size(); ++i) {
            ReferenceTranslations referenceTranslations = (ReferenceTranslations)this.referenceCorpus.get(i);
            referenceTranslations.addReference((Phrase)translations.get(i));
        }
    }

    public void setReferenceCorpus(ArrayList referenceCorpus) {
        this.referenceCorpus = referenceCorpus;
    }

    public ArrayList getReferenceCorpus() {
        return this.referenceCorpus;
    }

    public double calculateBleuScore(ArrayList candidateTranslations) {
        return this.calculateBleuScore(candidateTranslations, this.referenceCorpus);
    }

    public double calculateBleuScore(ArrayList candidateTranslations, ArrayList referenceCorpus) {
        HashMap numberOfMatchingNGrams = new HashMap();
        HashMap totalNGrams = new HashMap();
        int candidateCorpusLength = 0;
        int effectiveReferenceCorpusLength = 0;
        for (int i = 0; i < candidateTranslations.size(); ++i) {
            Phrase candidateTranslation = (Phrase)candidateTranslations.get(i);
            ReferenceTranslations referenceTranslations = (ReferenceTranslations)referenceCorpus.get(i);
            candidateCorpusLength += candidateTranslation.size();
            effectiveReferenceCorpusLength += referenceTranslations.getBestMatchLength(candidateTranslation);
            referenceTranslations.collectNGramCounts(candidateTranslation, numberOfMatchingNGrams, totalNGrams);
        }
        HashMap nGramPrecision = ReferenceTranslations.calculateNGramPrecision(numberOfMatchingNGrams, totalNGrams, this.maxNGram);
        double brevityPenalty = this.calculateBrevityPenalty(candidateCorpusLength, effectiveReferenceCorpusLength);
        return brevityPenalty * Math.exp(this.getWeightedSum(nGramPrecision));
    }

    private double calculateBrevityPenalty(int candidateCorpusLength, int effectiveReferenceCorpusLength) {
        if (candidateCorpusLength > effectiveReferenceCorpusLength) {
            return 1.0;
        }
        return Math.exp(1.0 - (double)effectiveReferenceCorpusLength / (double)candidateCorpusLength);
    }

    private double getWeightedSum(HashMap nGramPrecision) {
        double sum = 0.0;
        Iterator it = nGramPrecision.keySet().iterator();
        while (it.hasNext()) {
            Integer nGram = (Integer)it.next();
            double precision = (Double)nGramPrecision.get(nGram);
            double weight = this.nGramWeights[nGram - 1];
            if (!(precision > 0.0)) continue;
            sum += weight * Math.log(precision);
        }
        return sum;
    }

    public static ArrayList readInPhraseFile(String filename, Vocabulary vocab) throws IOException {
        ArrayList<Phrase> sentences = new ArrayList<Phrase>();
        BufferedReader reader = FileUtil.getBufferedReader(filename);
        while (reader.ready()) {
            Phrase sentence = new Phrase(reader.readLine(), vocab);
            sentences.add(sentence);
        }
        reader.close();
        return sentences;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage: Bleu candidateTranslations referenceTranslations (more reference translations ...)");
            System.exit(0);
        }
        Bleu blueScorer = new Bleu(4);
        Vocabulary vocabulary = new Vocabulary();
        for (int i = 1; i < args.length; ++i) {
            ArrayList referenceTranslations = Bleu.readInPhraseFile(args[i], vocabulary);
            blueScorer.addReferenceTranslations(referenceTranslations);
        }
        ArrayList candidateTranslations = Bleu.readInPhraseFile(args[0], vocabulary);
        System.out.println("Bleu score = " + blueScorer.calculateBleuScore(candidateTranslations));
    }

    public static void main2(String[] args) {
        Bleu blueScorer = new Bleu(4);
        Vocabulary vocab = new Vocabulary();
        ArrayList<Phrase> referenceSet = new ArrayList<Phrase>();
        referenceSet.add(new Phrase("it is a guide to action that ensures that the military will forever heed party commands", vocab));
        blueScorer.addReferenceTranslations(referenceSet);
        referenceSet = new ArrayList();
        referenceSet.add(new Phrase("it is the guiding principle which guarantees the military forces always being under the command of the party", vocab));
        blueScorer.addReferenceTranslations(referenceSet);
        referenceSet = new ArrayList();
        referenceSet.add(new Phrase("it is the practical guide for the army always to heed the directions of the party", vocab));
        blueScorer.addReferenceTranslations(referenceSet);
        ArrayList<Phrase> candidateSet1 = new ArrayList<Phrase>();
        candidateSet1.add(new Phrase("it is a guide to action which ensures that the military always obeys the commands of the party 1 2 3", vocab));
        ArrayList<Phrase> candidateSet2 = new ArrayList<Phrase>();
        candidateSet2.add(new Phrase("it is to insure the troops forever hearing the activity guidebook that party direct", vocab));
        System.out.println("Bleu score for first  = " + blueScorer.calculateBleuScore(candidateSet1));
        System.out.println("Bleu score for second = " + blueScorer.calculateBleuScore(candidateSet2));
    }
}

