/* ---------------------------------------------------------
   | Suzy 1.0 - RBF classifier system			   |
   | Copyright 1993 Tom Grove			           |
   |						           |
   | tvmain.hpp - class definitions for Turbo Vision       |
   ---------------------------------------------------------
*/

#if !defined( TVMAIN)
#define TVMAIN

#define Uses_TApplication
#define Uses_TStaticText
#define Uses_TButton
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TStatusLine
#define Uses_TKeys
#define Uses_TRect
#define Uses_TEvent
#define Uses_TDialog
#define Uses_TDeskTop
#define Uses_TSItem
#define Uses_TFileDialog
#define Uses_TPalette
#define Uses_MsgBox
#define Uses_TRadioButtons
#define Uses_TLabel
#define Uses_TInputLine

#include <tv.h>
#include <stdio.h>
#include <string.h>
#include "net.hpp"

// mypalette - feel free to change this if you can't stand my choice
// of colours (nobody else can!)

#define mypalette \
    "\x07\x13\x10\x1f\x31\x30\x3f"\
     "\x17\x1F\x1A\x31\x31\x1E\x71\x00" \
    "\x37\x3F\x3A\x13\x13\x3E\x21\x00\x70\x7F\x7A\x13\x13\x70\x7F\x00" \
    "\x10\x1F\x13\x13\x13\x17\x1B\x17\x1f\x30\x3B\x3F\x78\x3f\x10\x39" \
    "\x3F\x3E\x03\x0F\x19\x1f\x13\x31\x31\x0A\x07\x20\x03\x13\x00\x00"

const cmQueryNet = 201;
const cmStartTrainNet = 202;
const cmTestNet  = 203;
const cmSetupNet = 204;
const cmLoadTset = 205;
const cmLoadNet = 206;
const cmSaveNet = 207;
const cmStopTrainNet = 208;
const cmParameters = 209;
const cmFindNetWindow = 210;
const cmUpdateValues = 211;
const cmCloseNetWindow = 212;

// struct used in network parameters dialog box

struct NetParams
	{
	char rate[128];
	char iter[128];
	char toler[128];
	ushort mode;
	};

class SuzyApp : public TApplication
	{
	Net net;
	char flg;
	void Loader(void);
	void LoadNet(void);
	void SaveNet(void);
	void NetDialog(void);
	void SetupNet(void);
	void TestNet(void);
	TCommandSet netcmds;
	NetParams np;
public:
	static TMenuBar *initMenuBar(TRect );
	virtual TPalette& getPalette() const;
	virtual void handleEvent(TEvent &event);
	virtual void idle();
	SuzyApp();
	};

// NetWindow and NetWindowInterior provide the network status information

class NetWindow : public TWindow
	{
	public:
	virtual void handleEvent(TEvent&);
	NetWindow();
	};

class NetWindowInterior : public TView
	{
	float currentError;
	int currentIter;
	public:
	NetWindowInterior(const TRect&);
	virtual void draw(void);
	virtual void handleEvent(TEvent&);

	};
#endif