/* ----------------------------------------------------------
   | Suzy 1.0 - RBF classifier system			    |
   | Copyright 1993 Tom Grove			            |
   |						            |
   | tvmain.cpp - Turbo Vision application frame work       |
   ----------------------------------------------------------

   The Turbo Vision application framework. This is just a 'pretty'
   interface to 'Net''s member functions. It's not perfect - status
   line does nothing (TApplication's default status line is not overidden)
   and it is not as informative as it could be. Still, better than nothing.

*/

#include "tvmain.hpp"

NetWindowInterior::NetWindowInterior(const TRect& bounds) : TView(bounds)
	{
	growMode = gfGrowHiX | gfGrowHiY;
	options = options | ofFramed;
	currentError = 0.0;
	currentIter = 0;
	eventMask = 0xffff;
	}


void NetWindowInterior::handleEvent(TEvent& event)
	{
	TView::handleEvent(event);
	switch(event.message.command)
	{
	case cmUpdateValues:
		currentError = ((Net *)event.message.infoPtr)->getCErr();
		currentIter  = ((Net *)event.message.infoPtr)->getIter();
		drawView();
		break;
	}
	clearEvent(event);
	}

void NetWindowInterior::draw(void)
	{
	TView::draw();
	char buf[128];
	TDrawBuffer b;
	ushort color = getColor(0x301);
	sprintf(buf,"Error:     %.4f\0",currentError);
	b.moveStr(0,buf,color);
	writeLine(2,1,strlen(buf),1,b);
	sprintf(buf,"Iteration: %d\0",currentIter);
	b.moveStr(0,buf,color);
	writeLine(2,2,strlen(buf),1,b);
	}


void NetWindow::handleEvent(TEvent & event)
	{
	TWindow::handleEvent(event);
	switch(event.message.command)
		{
		case cmFindNetWindow:
			clearEvent(event);
			break;
		case cmCloseNetWindow:
			close();
			clearEvent(event);
			break;
		}
	}

NetWindow::NetWindow() : TWindow(TRect(10,10,40,16),"Net Window",0),
		  TWindowInit(&NetWindow::initFrame)
{
flags = 0x01;
insert(new NetWindowInterior(TRect(1,1,29,5)));
}




TPalette& SuzyApp::getPalette() const
	{
	static TPalette palette( mypalette , sizeof(mypalette)-1 );
	return palette;
	}


void SuzyApp::Loader(void)
	{
	ushort control;
	char filename[80];
	char *msg;
	TFileDialog *fd = new TFileDialog("*.dat","Open Training Set","~N~ame",fdOKButton,1);
	if(fd)  {
		control = deskTop->execView(fd);
		if(control != cmCancel)
			{
			net.newset();
			fd->getFileName(filename);
			if(!(msg = net.loadtset(filename)))
				{
				if(net.status() )
					enableCommands(netcmds);
				else    {
					enableCommand(cmSetupNet);
					}
				}
			else  { disableCommand(cmSetupNet);
				messageBox(msg,mfError|mfOKButton);
				}
			}
		}
	destroy(fd);
	}



void SuzyApp::TestNet(void)
	{
	ushort control;
	char filename[80];
	TFileDialog *fd = new TFileDialog("*.rep","Save Test Report","~N~ame",fdOKButton,1);
	if(fd)  {
		control = deskTop->execView(fd);
		if(control != cmCancel)
			{
			fd->getFileName(filename);
			if(!net.report(filename))
				messageBox("No test data available",mfInformation|mfOKButton);
			}
		}
	destroy(fd);
	}

void SuzyApp::LoadNet(void)
	{
	ushort control;
	char filename[80];
	TFileDialog *fd = new TFileDialog("*.net","Load Network","~N~ame",fdOKButton,1);
	if(fd)  {
		control = deskTop->execView(fd);
		if(control != cmCancel)
			{
			fd->getFileName(filename);
			if(net.initFile(filename))
				{
				if(net.status() )
					enableCommands(netcmds);
				else
					disableCommand(cmStartTrainNet);
				enableCommand(cmSaveNet);
				}
			else  {
				disableCommands(netcmds);
				messageBox("File Error",mfError|mfOKButton);
				}
			}
		}
	destroy(fd);
	}


void SuzyApp::SaveNet(void)
	{
	ushort control;
	char filename[80];
	TFileDialog *fd = new TFileDialog(net.name,"Save Network","~N~ame",fdOKButton,1);
	if(fd)  {
		control = deskTop->execView(fd);
		if(control != cmCancel)
			{
			fd->getFileName(filename);
			net.save(filename);
			}
		}
	destroy(fd);
	}

void SuzyApp::SetupNet()
	{
	int size;
	char buf[80];
	ushort control, mboxcontrol;
	TDialog *pd = new TDialog(TRect(10,5,44,12),"Create New Net");
	if(pd)
		{
		pd->insert(new TButton(TRect(22,2,32,4),"~O~K",cmOK,bfDefault));
		pd->insert(new TButton(TRect(22,4,32,6),"~C~ancel",cmCancel,bfNormal));
		TRadioButtons *rb = new TRadioButtons(TRect(2,3,21,5),
				new TSItem("Prototyped",
				new TSItem("Clustered",0)));
		pd->insert(rb);
		pd->insert(new TLabel(TRect(1,2,21,3),"RBF Centres",rb));
		ushort centerdata = net.getcenters();
		pd->setData(&centerdata);
		control = deskTop->execView(pd);
		if(control!=cmCancel)
			{
			if(!net.status() || (net.status() && messageBox("Creating a new net will destroy the current net. Continue?",mfWarning | mfYesButton | mfNoButton) == cmYes))
					{
				       pd->getData(&centerdata);
				       net.setcenters(centerdata);
				       size = net.init();
				       enableCommands(netcmds);
				       sprintf(buf,"New net created with %d RBF units in the hidden layer\0",size);
				       messageBox(buf,mfInformation|mfOKButton);
				       }
			}

		}
		destroy(pd);

	}

void SuzyApp::NetDialog()
	{
	ushort control;
	TDialog *pd = new TDialog(TRect(10,1,38,17),"Net Parameters");
	if(pd)
	  {
		pd->insert(new TButton(TRect(2,13,12,15),"~O~K",cmOK,bfDefault));
		pd->insert(new TButton(TRect(13,13,23,15),"~C~ancel",cmCancel,bfNormal));
		pd->insert(new TStaticText(TRect(2,2,21,3),"Training Parameters"));
		TInputLine *il1 = new TInputLine(TRect(15,4,25,5),128);
		pd->insert(il1);
		pd->insert(new TLabel(TRect(1,4,14,5),"Learning Rate",il1));
		TInputLine *il2 = new TInputLine(TRect(15,6,25,7),128);
		pd->insert(il2);
		pd->insert(new TLabel(TRect(1,6,14,7),"Max. Iter.",il2));
		TInputLine *il3 = new TInputLine(TRect(15,8,25,9),128);
		pd->insert(il3);
		pd->insert(new TLabel(TRect(1,8,14,9),"Tolerance",il3));
		TRadioButtons *bt = new TRadioButtons(TRect(14,10,25,12),
			new TSItem("~S~low",
			new TSItem("~N~ormal",0)));
		pd->insert(bt);
		pd->insert(new TLabel(TRect(1,10,14,11),"Mode",bt));
		pd->setData(&np);
		control = deskTop->execView(pd);
		if(control!=cmCancel)
			{
			pd->getData(&np);
			net.setlr( (float) strtod(np.rate,NULL));
			net.setmaxiter( (int) strtol(np.iter,NULL,0));
			net.settolerance( (float) strtod(np.toler,NULL));
			net.setmode((char)np.mode+1);
			}
	  }
	  destroy(pd);
	}


TMenuBar *SuzyApp::initMenuBar(TRect r)
	{
	r.b.y = r.a.y + 1;
	return new TMenuBar(r, *new TSubMenu("~F~ile",kbAltF) +
		*new TMenuItem("~O~pen training set",cmLoadTset, kbF3, hcNoContext,"F3")+
		*new TMenuItem("Open ~n~etwork",cmLoadNet,kbAltN,hcNoContext,"Alt-N")+
		*new TMenuItem("~S~ave network",cmSaveNet,kbAltS,hcNoContext,"Alt-S")+
		newLine()+
		*new TMenuItem("E~x~it",cmQuit, kbAltX, hcNoContext,"Alt-X")+
		*new TSubMenu("~S~uzy",kbAltS)+
		*new TMenuItem("Start ~t~raining",cmStartTrainNet, kbAltT, hcNoContext, "Alt-T")+
		*new TMenuItem("S~u~spend",cmStopTrainNet,kbAltR,hcNoContext,"Alt-U")+
		*new TMenuItem("Network Para~m~eters",cmParameters,kbAltM,hcNoContext,"Alt-M")+
		*new TMenuItem("~I~nit",cmSetupNet, kbAltI, hcNoContext, "Alt-I")+
		*new TMenuItem("T~e~st",cmTestNet, kbAltE, hcNoContext, "Alt-E"));
	}

SuzyApp::SuzyApp() : TProgInit( &SuzyApp::initStatusLine,
			&SuzyApp::initMenuBar,
			&SuzyApp::initDeskTop)
{
deskTop->redraw();
menuBar->drawView();
statusLine->drawView();
netcmds += cmStartTrainNet;
netcmds += cmStopTrainNet;
netcmds += cmSetupNet;
netcmds += cmQueryNet;
netcmds += cmTestNet;
netcmds += cmSaveNet;
disableCommands(netcmds);
enableCommand(cmLoadNet);
strcpy(np.rate,"0.005");
strcpy(np.iter,"5000");
strcpy(np.toler,"0.001");
np.mode = 0x01;
flg = NULL;
}

void SuzyApp::handleEvent(TEvent &event)
	{
	TApplication::handleEvent(event);
	if(event.what == evCommand)
		{
		switch(event.message.command)
			{
		case cmLoadTset:
			Loader();
			break;
		case cmLoadNet:
			LoadNet();
			break;
		case cmParameters:
			NetDialog();
			break;
		case cmSaveNet:
			SaveNet();
			break;
		case cmSetupNet:
			SetupNet();
			break;
		case cmStartTrainNet:
			if(!message(deskTop,evBroadcast,cmFindNetWindow,0))
				{
				net.trainingInit();
				deskTop->insert(new NetWindow);
				flg = !NULL;
				disableCommand(cmStartTrainNet);
				enableCommand(cmStopTrainNet);
				}
				break;
		case cmStopTrainNet:
			flg = NULL;
			message(deskTop,evBroadcast,cmCloseNetWindow,0);
			enableCommand(cmStartTrainNet);
			disableCommand(cmStopTrainNet);
			break;
		case cmTestNet:
			TestNet();
			break;
		default:
			return ;
			}
		clearEvent(event);
		}
	}

// TApplication::idle() is overidden to provide cheap multi-tasking

void SuzyApp::idle()
	{
	int control;
	TApplication::idle();
	if(flg)
		{
		control = net.train();
		message(deskTop,evBroadcast,cmUpdateValues,&net);
		if(control!=NULL)
			{
			flg = NULL;
			}
		}
	}


int main(void)
	{
	SuzyApp myapp;
	myapp.run();
	return 0;
	}
