/* ---------------------------------------------------------
   | Suzy 1.0 - RBF classifier system			   |
   | Copyright 1993 Tom Grove			           |
   |						           |
   | token.hpp - header file for token.cpp		   |
   ---------------------------------------------------------

token.hpp provides the class definitions for a training set parser
(format is described in the documentation)

*/


#if !defined( TSET )
#define TSET

// Macro used for error messages

#define EXIT(x) sprintf(msg,x ## " at line %d\n",lines); fs.close(); return NULL;

#include <fstream.h>
#include <alloc.h>
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

// Fact - each training set is made of a number of facts (patterns/samples
// examples) each consisting of a number of attributes (floats) and a
// single class (sorry - a fact can only belong to one class)

struct Fact {
	float *attribs;
	int clss ;
	Fact(int number) { attribs = new float[number]; }
	~Fact(void) { delete attribs; }
	    };

// Tset - training set class. Provides member functions for loading,
// parsing and using training and test sets.

class Tset  {
	int tsetsize, testsetsize;
	int lines;
	int noattributes, noclasses, novalues;
	float *tokenvalues;
	char **tokennames;
	Fact **trainingset;
	Fact **testset;
	int gettoken(fstream&);
	int getnextchar(void);
	int parseheader(void);
	int parsefactdefs(void);
	int parsefacts(Fact **,int);
	char token [80];
public:
	char msg[80];
	char name[80];
	fstream fs ;
	int open(char *filename)
			{
			fs.open(filename,ios::in);
			if(!fs) {
				EXIT("Error opening file");
				}
			else return !NULL;
			}
	int load(char *);
	void Tset::clear(void);
	int nofacts(void) { return tsetsize; }
	int notestfacts(void) { return testsetsize;}
	int noattrs(void) { return noattributes; }
	int noclass(void) { return noclasses; }
	float fact(int factno,int attrno)
		{ return  (trainingset[factno]->attribs[attrno]); }
	float testfact(int factno, int attrno)
		{ return  (testset[factno]->attribs[attrno]); }
	int factclass(int factno)
		{ return (trainingset[factno]->clss);}
	int testfactclass(int factno)
		{ return (testset[factno]->clss); }
	Tset(void)
		{ tokenvalues = NULL;
		  tokennames = NULL;
		  lines = 1;
		  trainingset = NULL;
		  tsetsize = 0;
		  testset = NULL ;}
	~Tset()
		{ clear(); }
		 };

#endif
