/* ---------------------------------------------------------
   | Suzy 1.0 - RBF classifier system			   |
   | Copyright 1993 Tom Grove			           |
   |						           |
   | rbf.hpp -  header file for rbf.cpp			   |
   ---------------------------------------------------------

defines a five class hierachy, but is a bit of a mess. The hierachy is

Layer :----- FCLayer -------- OutputLayer
	 |                 |
	 --- InputLayer    -- HiddenLayer

FCLayer stands for fully connected layer. InputLayer is a simple
interface to the training set. HiddenLayer holds the various member
functions for the RBF units. OutputLayer implements a simple delta-rule
perceptron. Needs substantial improvement, but works.


*/

#if !defined (RBF)
#define RBF

#include <stdlib.h>
#include <iostream.h>
#include <math.h>
#include "token.hpp"

#define TRAIN 1
#define TEST  3
#define HYPER 2

class Layer
	{
	public:
	Tset *training;
	void setTset(Tset *ts) { training = ts;}
	virtual int layer_size() = 0;
	virtual void actlayer(int,int) = 0;
	virtual float output(int) = 0;
	};

class FCLayer : public Layer
	{
public:
	float *outputs;
	char **hyper_table;
	int units;
	int connections;
	float **wtmatrix;
	Layer *previous;
	void create(void);
	void hyperinit(void);
	void destroy(void);
	void save(fstream&);
	void initFile(fstream&);
	int layer_size(void)
		{ return units; }
	float output(int unit)
		{ return outputs[unit]; }
	virtual void actlayer(int,int);
	virtual void init(void)  = 0;
	virtual float activation_fn(int)  = 0;
	virtual float output_fn(float )  = 0;
	FCLayer(void) { hyper_table = NULL; }
	};


class HiddenLayer : public FCLayer
	{
	float lrate;
	float radius;
	float *radii;
	void setcentre(int,int);
	void setradius(void);

public:
	float globalact;
	virtual float activation_fn(int);
	virtual void actlayer(int,int);
	virtual float output_fn(float input) { if(input<radius) return 1.0;
						else return 0.0; }
	void init(void);
	void initPrototypes(void);
	void save(fstream&);
	void initFile(fstream&);
	void showunits(void);

	HiddenLayer(Layer *pl)
		{
		previous = pl;
		wtmatrix = NULL;
		connections = units = 0;
		radii = NULL;
		radius = 0.001;
		}
	~HiddenLayer()
		{
		if(radii) delete radii;
		destroy();
		}
	};

class OutputLayer : public FCLayer
	{
	float *biases ;
public:
	virtual float activation_fn(int);
	virtual float output_fn(float input) { return input; }
	virtual void init(void);
	float learn(int,float lr);
	void save(fstream&);
	void initFile(fstream&);
	OutputLayer(Layer *pl)
		{
		previous = pl;
		wtmatrix = NULL;
		biases = NULL;
		units = 0;
		connections = 0;
		}
	~OutputLayer()
		{
		if(biases) delete biases;
		destroy();
		}
	};

class InputLayer : public Layer
	{
	int fact;
	int type;
public:
	int layer_size(void)
		{ return  training->noattrs(); }
	void actlayer(int f,int t)
		{ fact = f;
		  type = t;}
	float output(int unit);
	void showfacts(void);
	InputLayer(void)
		 {
		 fact = 0;
		 type = TRAIN;
		 }
	};

#endif












