/* ----------------------------------------------------------
   | Suzy 1.0 - RBF classifier system			    |
   | Copyright 1993 Tom Grove			            |
   |						            |
   | rbf.cpp -  member function definitions for the various |
   | classes that make up the RBF network.		    |
   ----------------------------------------------------------

   Some of this code is quite bad.....

*/

#include "rbf.hpp"
#include <iostream.h>
#include <stdlib.h>

// Various functions for saving and loading layers

void FCLayer::save(fstream& fs)
	{
	int i,j;
	fs << units << endl;
	fs << connections << endl;
	for(i=0;i<units;i++)
		for(j=0;j<connections;j++)
			fs << wtmatrix[i][j] << endl;
	}

void FCLayer::initFile(fstream& fs)
	{
	int i,j;
	fs >> units;
	wtmatrix = new float *[units];
	outputs = new float [units];
	fs >> connections;
	for(i=0;i<units;i++)
		wtmatrix[i] = new float[connections];
	for(i=0;i<units;i++)
		for(j=0;j<connections;j++)
			{
			fs >> wtmatrix[i][j] ;
			}
	}

void OutputLayer::save(fstream& fs)
	{
	int i;
	FCLayer::save(fs);
	for(i=0;i<units;i++)
		fs << biases[i] << endl;
	}

void OutputLayer::initFile(fstream& fs)
	{
	int i;
	FCLayer::initFile(fs);
	biases = new float[units];
	for(i=0;i<units;i++) {
			fs >> biases[i] ;
			}
	}

void HiddenLayer::save(fstream& fs)
	{
	int i;
	FCLayer::save(fs);
	for(i=0;i<units;i++)
		fs << radii[i] << endl;
	}

void HiddenLayer::initFile(fstream& fs)
	{
	int i;
	FCLayer::initFile(fs);
	radii = new float[units];
	for(i=0;i<units;i++)
		fs >> radii[i];

	}


// Straight forward activation function for the output layer

float OutputLayer::activation_fn(int unit)
	{
	int i;
	float sum = 0.0;
	for(i=0;i<connections;i++)
		sum += wtmatrix[unit][i] * previous->output(i);
	sum += biases[unit];
	return sum;
	}

// Random initialisation of output layer weights

void OutputLayer::init(void)
	{
	int i,j;
	units = training->noclass();
	connections = previous->layer_size();
	biases = new float [units];
	create();
	for(i=0;i<units;i++)  {
		for(j=0;j<connections;j++)
			wtmatrix[i][j] = ((float) random(100)/100) - ((float) random(100)/100);
		biases[i] = ((float) random(100)/100) - ((float) random(100)/100);
			      }
	}

// Delta-rule learning. lr is the learning rate

float OutputLayer::learn(int factno,float lr)
	{
	int i,j;
	float value;
	float error, sumerror = 0.0;
	int target_class = training->factclass(factno);
	for(i=0;i<units;i++)
		{
		if(i==target_class)
			value = 1.0;
		else
			value = 0.0;
		error = value - output(i);
		for(j=0;j<connections;j++)
			wtmatrix[i][j] += (error * previous->output(j) * lr);
		biases[i] += error * lr;
		sumerror += pow(error,2);
		}
	return sumerror/units;
	}




// activation function for RBF units. Activation = distance
// (from fact) minus radius of unit

float HiddenLayer::activation_fn(int unit)
	{
	int i;
	float sum = 0.0;
	for(i=0;i<connections;i++)
		sum += pow(wtmatrix[unit][i]-previous->output(i),2);
	return sqrt(sum)-radii[unit];
	}



// set centre of RBF unit to fact - used by initPrototypes below.

void HiddenLayer::setcentre(int unit,int fact)
	{
	int i;
	for(i=0;i<connections;i++)
		wtmatrix[unit][i] = training->fact(fact,i);
	}


// Set the radius of all RBF units to average distance (when
// using prototypes)

void HiddenLayer::setradius(void)
	{
	int i,j,k;
	float sum =0.0;
	float total;
	for(i=0;i<units;i++) {
		for(j=0;j<units;j++)
			{
			total =0.0;
			for(k=0;k<connections;k++) {
				total += pow(wtmatrix[i][k]-wtmatrix[j][k],2);
				total = sqrt(total);
						   }
	    //	if(total == 0.0 && training->factclass(j)!=training->factclass(i))
			  //	cout << "Possible contradiction between fact " << j << " and fact " << i << endl;
			}
		sum += total/units;
			}
	radius = sum/units;
	}

// initPrototypes - set all hidden units to members of the
// training set. Every training fact is used, radius is
// equal to average distance.

void HiddenLayer::initPrototypes(void)
	{
	int i;
	units = training->nofacts();
	radii = new float[training->nofacts()];
	connections = previous->layer_size();
	wtmatrix = new float *[training->nofacts()];
	for(i=0;i<units;i++) {
		wtmatrix[i] = new float[connections];
		setcentre(i,i);
			      }
	outputs = new float[units];
	setradius();
	for(i=0;i<units;i++) radii[i] = radius;
	}

// Ugh! I've had nightmares about this function. It looks
// awful and isn't even efficient. This implements the class
// based clustering algorithm and creates a new hidden unit
// for every cluster found. It creates a few unessacery clusters
// and is quite slow. Desparately needs improving.

void HiddenLayer::init(void)
	{
	radii = new float[training->nofacts()];
	connections = previous->layer_size();
	wtmatrix = new float *[training->nofacts()];
	float *temp = new float[connections];
	int number = training->nofacts();
	char *tag = new char[number];
	int i,j,k,l,c;
	float most_distant_thisclass,old,nearest_other;
	for(i=0;i<number;i++) tag[i] = -1;
	do      {
		for(i=0;i<number;i++)
			if(tag[i] == -1)
					{
				wtmatrix[units] = new float[connections];
				setcentre(units,i);
				radii[units] = 0.0;
				tag[i] = units;
				c = training->factclass(i);
				break;
					}
		if(i==number)  break;

	for(i=0;i<number;i++)
		{
		if(tag[i] == -1 && (training->factclass(i)==c))
			{
			for(k=0;k<connections;k++) {
				temp[k] = wtmatrix[units][k] ;
				wtmatrix[units][k] = (wtmatrix[units][k]+training->fact(i,k))/2;
				}
			old = radii[units];
			radii[units] = 0.0;

			most_distant_thisclass = -1.0;
			nearest_other = 99999.9;

			for(k=0;k<number;k++)
				{
				previous->actlayer(k,TRAIN);
			if(training->factclass(k) != c && activation_fn(units) < nearest_other)
				{
				nearest_other = activation_fn(units);
				}
			else if(tag[k] == units && activation_fn(units) > most_distant_thisclass)
				{
				most_distant_thisclass = activation_fn(units);
				}
				}

			if(most_distant_thisclass < nearest_other)
				{
				tag[i] = units;
				radii[units] = most_distant_thisclass ;
				}
			else    {
				radii[units] = old;
				for(k=0;k<connections;k++)
					wtmatrix[units][k] = temp[k];
				}
			}
		}
		units++;
		} while(1==1);

	outputs = new float[units];
	delete temp;
	delete tag;
	}



// InputLayer output function - just returns a component of Tset.

float InputLayer::output(int unit)
	{
	if(type==TRAIN)
			return training->fact(fact,unit);
	else
			return training->testfact(fact,unit);
	}

// allocate memory for layer - should really be in the constructer

void FCLayer::create(void)
	{
	int i;
	int pl = previous->layer_size();
	outputs  = new float [units];
	wtmatrix = new float *[units];
	for(i=0;i<units;i++)
		wtmatrix[i] = new float[pl];
	}


// initialise the lookup table used in 'fast' training
// (actually called 'normal' now in the TV interface
// because it isn't that fast....  )

void FCLayer::hyperinit(void)
	{
	int i;
	hyper_table = new char *[training->nofacts()];
	for(i=0;i<training->nofacts();i++)
		hyper_table[i] = NULL;
	}

// free memory used by layer - should be in the destructor

void FCLayer::destroy(void)
	{
	int i;
	delete outputs;
	for(i=0;i<units;i++)
		delete wtmatrix[i];
	delete wtmatrix;
	if(hyper_table != NULL)
		{
		for(i=0;i<training->nofacts();i++)
			if(hyper_table[i]!=NULL) delete hyper_table[i];
		delete hyper_table;
		hyper_table = NULL;
		}
	}

// activate hiddenlayer - use the lookup table if it exists.

void HiddenLayer::actlayer(int factno,int type)
	{
	int i;
	float temp;
	if(type==HYPER)
		{
		if(hyper_table[factno]==NULL)
			{
			hyper_table[factno] = new char[units];
			previous->actlayer(factno,TRAIN);
				for(i=0;i<units;i++)
					{
					temp = output_fn(activation_fn(i));
					outputs[i] = temp;
					hyper_table[factno][i] = (char) temp;
					}
			}
		else  for(i=0;i<units;i++)
			outputs[i] = (float) hyper_table[factno][i];
		}
	else
		{
	previous->actlayer(factno,type);
	globalact= 0.0;
	for(i=0;i<units;i++) {
		outputs[i] = output_fn( activation_fn(i) );
		globalact += outputs[i];
			}
		}
	}

// base actlayer - used by Outputlayer 'as is' and not
// overidden.

void FCLayer::actlayer(int factno,int type)
	{
	int i;
	previous->actlayer(factno,type);
	for(i=0;i<units;i++)
		outputs[i] = output_fn( activation_fn(i) );
	}


