/* ---------------------------------------------------------
   | Suzy 1.0 - RBF classifier system			   |
   | Copyright 1993 Tom Grove			           |
   |						           |
   | net.hpp -  header file for net.cpp			   |
   ---------------------------------------------------------


   defines the net class. This holds the layer objects defined in
   rbf.hpp and has member functions concerned with training and
   testing,  loading and saving.

*/

#if !defined( NET )
#define NET

#include <math.h>
#include "token.hpp"
#include "rbf.hpp"

#define PROTOTYPED 0   // type of network
#define CLUSTERED 1


class Net {
	Tset set;
	char trainable;
	float lrate;
	int maxiter;
	int Iter;
	float CErr;
	float tolerance;
	char tmode;
	unsigned char centers;
	InputLayer *input;
	HiddenLayer *hidden;
	OutputLayer *output;
public:
	char name[80];
	int train(void);
	float report(char *);
	char status(void) { return trainable;}
	int enquire(float *);
	int initFile(char *);
	int save(char *);
	void setlr(float rate) { lrate = rate;}
	void setmaxiter(int max) { maxiter = max;}
	void settolerance(float tt) { tolerance = tt;}
	void setmode(char m) { tmode = m;}
	void setcenters(unsigned char c) { centers = c;}
	unsigned char getcenters(void) { return centers;}
	int getIter(void) { return Iter;}
	float getCErr(void) { return CErr;}
	void trainingInit(void);
	char *loadtset(char *filename)
		{
		if(set.load(filename) == NULL)
			return set.msg;
		else	if(input!=NULL)
				{ input->setTset(&set);
				  hidden->setTset(&set);
				  hidden->hyperinit();
				  output->setTset(&set);
				  trainable = !NULL;
				  }
			else
				trainable = NULL;
			return NULL;
		}
	void newset(void)
		{
		set.clear();
		trainable = NULL;
		}
	int init(void);
	void destroy(void) {
		if(input!=NULL)
			{ delete input;
			  delete hidden;
			  delete output;
			  }
		input = NULL;
		hidden = NULL;
		output = NULL;
		}
	 Net() { input = NULL;
		 trainable = NULL;
		 maxiter = 5000;
		 tolerance = 0.001;
		 lrate = 0.005;
		 centers = PROTOTYPED;
		 tmode = HYPER;
		 strcpy(name,"NONAME.NET"); }
	~Net() {
		destroy();
		}
	};

#endif

