 /* --------------------------------------------------------
   | Suzy 1.0 - RBF classifier system			   |
   | Copyright 1993 Tom Grove			           |
   |						           |
   | net.hpp-  member functions for network class 	   |
   ---------------------------------------------------------

   Provides definitions for the various member functions related
   to training and testing.

 */

#include <fstream.h>
#include "net.hpp"


// Saving and loading functions

int Net::save(char *filename)
	{
	strcpy(name,filename);
	fstream fs;
	fs.open(filename,ios::out);
	if(!fs)
		return NULL;
	else    {
		hidden->save(fs);
		output->save(fs);
		fs.close();
		}
	return !NULL;
	}

int Net::initFile(char *filename)
	{
	fstream fs;
	fs.open(filename,ios::in);
	if(!fs)
		return NULL;
	else
		{
		strcpy(name,filename);
		destroy();
		input = new InputLayer();
		hidden = new HiddenLayer(input);
		hidden->initFile(fs);
		output = new OutputLayer(hidden);
		output->initFile(fs);
		fs.close();
		if(set.nofacts()!=0)
			{
			input->setTset(&set);
			hidden->setTset(&set);
			output->setTset(&set);
			trainable = !NULL;
			hidden->hyperinit();
			}
		else   trainable = NULL;
		}
	return !NULL;
	}

// Create a new network based on the current training set.

int Net::init()
	{
	if(set.nofacts()!=0)
			{
		input = new InputLayer();
		input->setTset(&set);
		hidden = new HiddenLayer(input);
		hidden->setTset(&set);
			if(centers == PROTOTYPED)
				hidden->initPrototypes();
			else
				hidden->init();
		hidden->hyperinit();
		output = new OutputLayer(hidden);
		output->setTset(&set);
		output->init();
		trainable = !NULL;
			}
	else
		trainable = NULL;
	return hidden->layer_size();
		}

// train - trains the network for one epoch - i.e. , one iteration through
// the training set.

int Net::train(void)
	{
	int i;
	int facts = set.nofacts();
	float neterror;
	   neterror = 0.0;
	   for(i=0;i<facts;i++)
		{

		output->actlayer(i,tmode);
		neterror += output->learn(i,lrate);
		}
		neterror /= facts;
	CErr=  neterror;
	Iter++;
	if(CErr<tolerance||Iter>maxiter) return !NULL;
	else return NULL;
	}

void Net::trainingInit(void)
	{
	CErr = 0.0;
	Iter = 0;
	}


// Generate a test report file

float Net::report(char *filename)
	{
	fstream fs;
	int decision,i,j,biggest, facts = set.notestfacts();
	int correct = 0;
	int rejects = 0;
	float df,dv;
	if(facts==0) return NULL;
	fs.open(filename,ios::out);
	if(!fs)
		return NULL;
	fs << "Net: " << name << endl;
	fs << "Training set: " << set.name << endl << endl;
	for(i=0;i<facts;i++)
		{
		output->actlayer(i,TEST);
		if(hidden->globalact>0.0)
			{
		dv = 0.0;
		df = 0.0;
		for(j=0;j<output->units;j++)
			{
			if(output->output(j)>dv)
				{
				dv = output->output(j);
				decision = j;
				}
			}
		for(j=0;j<output->units;j++)
			{
			if((fabs(output->output(j) - dv))>df)
				{
				df = fabs(output->output(j)-dv);
				}
			}
		fs << "Test fact " << i << " of class " << set.testfactclass(i) << " classified as " << decision << " with certainty " << df;
		if(set.testfactclass(i) == decision)
			{
			fs << " <YES> " << endl;
			correct++;
			}
		else	fs << " <NO> " << endl;
			}
		else	{
			fs << "Test fact " << i << " <REJECTED>" << endl;
			rejects++;
			}
		}
	fs << endl << "Final result: " << correct << " Correct out of " << facts ;
	fs << " (" << (((float)correct/(float)facts)*100) << "%)" << endl;
	fs << rejects << " Rejects" << endl;
	fs.close();
	return !NULL;
	}





