/*  $Id: rnsproc.c,v 1.5 1991/10/10 16:46:26 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rnsproc.c,v $
 * Revision 1.5  1991/10/10  16:46:26  richard
 * Switched to UNIX RCS
 *
 * Revision 1.4  91/05/09  14:42:24  ROOT_DOS
 * Added USERERR learn mode property and user defined error function
 * 
 * Revision 1.3  91/02/17  14:29:56  ROOT_DOS
 * Minor changes
 * Added comments
 *
 * Revision 1.2  91/02/05  01:29:10  ROOT_DOS
 * Minor change: wrong number of pointers was reserved in argv
 *
 * Revision 1.1  91/02/02  00:56:11  ROOT_DOS
 * Initial revision
 *   */



/*  procedure versie van RNS, zodat RNS in   */
/*  een ander programma gebruikt kan worden  */


#include "rnsdefs.h"     /*  alleen in RNSPROC.C zonder EXTERN  */
#include "rnsfuncs.h"

#include "rnsproc.h"


#ifdef TURBOC
#include <stddef.h>
#else
#include <stddef.h>
#endif



#ifdef USEPROTOS
int rnsproc(char *in, char *out, char *log, char *options)
#else
int rnsproc(in, out, log, options)
       char *in;
       char *out;
       char *log;
       char *options;
#endif
{
int rc = OK;

int  argc;
char *argv[6];


   /*  zet alle argumenten in een 'geemuleerde' versie van argc en argv  */
   argv[argc=0]=PROGRAM;
   if (in!=NULL)
      argv[++argc]=in;
   if (out!=NULL)
      argv[++argc]=out;
   if (log!=NULL)
      argv[++argc]=log;
   if (options!=NULL)
      argv[++argc]=options;
   argv[++argc]=NULL;    /*  sluit argv af met NULL  */


   /*  de rest van RNSPROC.C is identiek aan RNS.C  */

   rc=init();                   /*  initialiseer variabelen         */

   if (rc==OK)                  /*  als OK, verwerk dan argumenten  */
      rc=process_args(argc, argv);

   if (rc==OK)                  /*  als OK, lees dan invoerbestand  */
      rc=read_input();

   if (rc==OK)                  /*  als OK, controleer dan  */
      rc=check_input();         /*  ingevoerde gegevens     */

   if (rc==OK)                  /*  als OK, open dan grafisch scherm  */
      rc=open_graphics();

   if (rc==OK)                  /*  als OK, doe berekeningen met netwerk  */
      rc=process_net();

   if (rc==OK)                  /*  als OK, doe tests op patronen  */
      rc=run_tests();

   if (rc==OK)                  /*  als OK, laat dan resultaten zien  */
      rc=show_results();

   close_graphics();            /*  sluit grafisch scherm  */

   if (rc==OK)                  /*  schrijf resultaten naar uitvoerbestand  */
      rc=write_output();

   clean_up();                  /*  ruim geheugen op  */

   if (rc!=OK)                  /*  als niet OK, verwerk dan fout  */
      process_error(rc);

   return(rc);
}
