/*  $Id: rnslog.c,v 1.8 1991/10/10 16:46:21 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rnslog.c,v $
 * Revision 1.8  1991/10/10  16:46:21  richard
 * Switched to UNIX RCS
 *
 * Revision 1.7  91/02/26  21:50:28  ROOT_DOS
 * Added comments
 * 
 * Revision 1.6  91/02/17  14:29:12  ROOT_DOS
 * Minor changes
 *
 * Revision 1.5  91/02/01  23:31:38  ROOT_DOS
 * Minor changes
 *
 * Revision 1.4  91/01/30  21:44:40  ROOT_DOS
 * Forget ANSI C and make traditional C / Turbo C dual mode
 *
 * Revision 1.3  91/01/27  21:03:54  ROOT_DOS
 * Changed code to show the last error value reached
 *
 * Revision 1.2  90/12/08  03:51:22  ROOT_DOS
 * Some minor cosmetic changes
 *
 * Revision 1.1  90/12/08  03:16:47  ROOT_DOS
 * Initial revision
 *   */



/*  functies voor het loggen van data  */


#define EXTERN
#include "rnsdefs.h"
#include "rnsfuncs.h"


#ifdef TURBOC
#include <stdio.h>
#include <time.h>
#else
#include <stdio.h>
#include <time.h>
#endif



#ifdef USEPROTOS
int log_start(void)
#else
int log_start()
#endif
{
time_t  time_now;
char *  time_str;

   if (logging==TRUE)                  /*  als log optie waar is  */
   {
      if ((log_file=fopen(log_name, LOGMODE))==NULL)
         return(OPNLOG);               /*  open logbestand    */
      time(&time_now);                 /*  bepaal de tijd     */
      time_str=ctime(&time_now);       /*  maak tekst versie  */
      /*  druk log header af met bestandsnamen en tijd        */
      fprintf(log_file, "%s:  %s\n", RNSNAME, VERSION);
      fprintf(log_file, "%s:  %s\n", RNSNAME, input_name);
      fprintf(log_file, "%s:  --> %s\n", RNSNAME, output_name);
      fprintf(log_file, "%s:  START: %s", RNSNAME, time_str);
      if (fclose(log_file)==EOF)
         return(CLSLOG);               /*  sluit logbestand   */
   }

   return(OK);
}



#ifdef USEPROTOS
int log_info(boolean info)
#else
int log_info(info)
       boolean info;
#endif
{
int rc = OK;

   if (logging==TRUE)                  /*  als log optie waar is  */
   {
      if (step>0 && ((step % LOGSTEP)==0 || info))
      {                                /*  om de LOGSTEP stappen of geforceerd met info  */
         if ((log_file=fopen(log_name, LOGMODE))==NULL)
            return(OPNLOG);            /*  open logbestand   */
         /*  druk aantal stappen af en de totale fout        */
         fprintf(log_file, "%s:  step = %3ld,  error = %7.4f\n",
                           RNSNAME, step, total_error);
         if (fclose(log_file)==EOF)
            return(CLSLOG);            /*  sluit logbestand  */
      }

      if (((step % (10*LOGSTEP))==0 && (rc=write_output())!=OK) || info)
         return(rc);                   /*  schrijf resultaten om de 10*LOGSTEP stappen  */
   }

   return(OK);
}



#ifdef USEPROTOS
int log_end(void)
#else
int log_end()
#endif
{
time_t  time_now;
char *  time_str;

   if (logging==TRUE)                  /*  als log optie waar is  */
   {
      if ((log_file=fopen(log_name, LOGMODE))==NULL)
         return(OPNLOG);               /*  open logbestand   */
      time(&time_now);                 /*  bepaal de tijd    */
      time_str=ctime(&time_now);       /*  maak een tekst versie  */
      /*  druk de eindtijd af  */
      fprintf(log_file, "%s:  END:   %s", RNSNAME, time_str);
      if (fclose(log_file)==EOF)
         return(CLSLOG);               /*  sluit logbestand  */
   }

   return(OK);
}
