/*  $Id: rnsclean.c,v 1.10 1991/10/10 16:44:57 richard Exp richard $  */

/*  Part of RNS -- Recurrent Network Simulator
 *
 *     by R. Kooijman
 *        T.U. Delft
 *        Faculteit Elektrotechniek
 *        Vakgroep Computerarchitectuur
 *        Sectie Neurale Netwerken
 */


/*  $Log: rnsclean.c,v $
 * Revision 1.10  1991/10/10  16:44:57  richard
 * Switched to UNIX RCS
 * Added clean up of random bit patterns
 *
 * Revision 1.9  91/02/26  21:49:21  ROOT_DOS
 * Added comments
 *
 * Revision 1.8  91/02/17  14:28:05  ROOT_DOS
 * Minor changes
 *
 * Revision 1.7  91/02/05  09:18:29  ROOT_DOS
 * Made new REALLOC and FREE functions to support older style realloc and free
 *
 * Revision 1.6  91/02/01  23:28:49  ROOT_DOS
 * Added checks for pointers being NULL
 *
 * Revision 1.5  91/01/30  21:43:55  ROOT_DOS
 * Forget ANSI C and make traditional C / Turbo C dual mode
 *
 * Revision 1.4  91/01/27  21:01:44  ROOT_DOS
 * Changes to make code strict ANSI C compatible
 *
 * Revision 1.3  91/01/19  22:23:59  ROOT_DOS
 * Added removal of temporary storage of patterns
 *
 * Revision 1.2  90/12/08  03:50:46  ROOT_DOS
 * Some minor cosmetic changes
 *
 * Revision 1.1  90/12/08  03:14:32  ROOT_DOS
 * Initial revision
 *   */



/*  functies voor het opruimen van het geheugen  */


#define EXTERN
#include "rnsdefs.h"
#include "rnsfuncs.h"

#include "rnsalloc.h"
#include "rnstty.h"


#ifdef TURBOC
#include <alloc.h>
#else
#include <stdlib.h>
#endif



#ifdef USEPROTOS
void clean_up(void)
#else
void clean_up()
#endif
{
int pattern;
Neuronptr   neuronptr;
Patternptr  patternptr;

   for (neuronptr=neuronlist; neuronptr!=NULL; )
   {                                   /*  ga alle neuronen af              */
      neuronlist=neuronptr->next;      /*  wijs alvast naar de volgende     */
      FREE(neuronptr->constraint);     /*  geef geheugen constraints terug  */
      FREE(neuronptr->weights);        /*  geef geheugen gewichten terug    */
      FREE(neuronptr);                 /*  geef geheugen neuron terug       */
      neuronptr=neuronlist;            /*  ga naar volgende neuron          */
   }

   FREE(inputlistptr);          /*  geef geheugen voor invoerneuronenlijst terug   */
   FREE(outputlistptr);         /*  geef geheugen voor uitvoerneuronenlijst terug  */

   for (pattern=0; pattern<nrpatterns+nrtests; pattern++)
   {                                   /*  ga alle patroonnummers af                 */
      patternptr=GETPATTERN(pattern);  /*  wijs naar het eigenlijke patroon          */
      FREE(patternptr->in);            /*  geef geheugen voor invoerpatronen terug   */
      FREE(patternptr->out);           /*  geef geheugen voor uitvoerpatronen terug  */
      FREE(patternptr->result);        /*  geef geheugen voor resultaten terug       */
      FREE(patternptr);                /*  geef geheugen van patroon terug           */
   }

   FREE(patternlistptr);        /*  geef geheugen voor patronenlijst terug  */

   FREE(input_pattern);         /*  geef geheugen terug van invoerpatroon   */
   FREE(output_pattern);        /*  geef geheugen terug van uitvoerpatroon  */

   vtohcleanup();               /*  geef geheugen terug van vtoh routines   */

   FREE(orig_input);
   FREE(trans_input);
   FREE(orig_output);
   FREE(trans_output);
   FREE(plot_line);

#ifdef UNIX
   tty_reset();
#endif
}
