'Compile with Quick basic 4.5
'
'This program simulates a neural net acting like a flip-flop.
'Try it with different weight adjustments (W = 3, W = 4, W = 5).
'
' ------------------------------------------------------------
'
' Mark Hopkins (markh@csd4.csd.uwm.edu)
' November 12, 1990
' Milwaukee, Wisconsin

declare function SIGMA#(x as single)
dim Y as single, Z as single, Y1 as single, Z1 as single
dim W as single, A as single, B as single

cls
locate 4, 1
print "(Q) ... Pause [(S)... Resume]"
print "(R) ... Reset"
print "(S) ... Set"
print "(1) ... All inputs high"
print "(0) ... All inputs low"
print "(C) ... Quit"

W = 6: A = 1: B = 1
Y = .3: Z = 0
do
   locate 2, 1: print using "##, ##"; A; B
   do
      select case inkey$
         case "q", "Q": do: Ch$ = inkey$: loop while Ch$ <> "s" and Ch$ <> "S"
         case "c", "C": end
         case "r", "R": A = 1: B = 0: exit do
         case "s", "S": A = 0: B = 1: exit do
         case "1": A = 1: B = 1: exit do
         case "0": A = 0: B = 0: exit do
      end select
      locate 1, 1: print using "##.######, ##.######"; Y; Z
      Y1 = SIGMA#(W*(0.5 - A - Z)): Z1 = SIGMA#(W*(0.5 - B - Y))
      Y = Y1: Z = Z1
   loop
loop
end

function SIGMA#(x as single)
   SIGMA# = 1/(1 + exp(-x))
end function
