%
% EXAMPLE CMAC2D: TRAINS NETWORK FOR CANCELLATION CONTROLLER
% Compare this with the example CSTRAIN in chapter 8 of
% the Neural Network Toolbox Users Manual from which it is derived.
%
% A two input single output CMAC network
% is trained on a 400 pattern problem.
%

% written 13 August 1993 by Donald Reay
%
% Power Electronics Group
% Department of Computing and Electrical Engineering
% Heriot-Watt University
% Edinburgh UK
%
% e-mail dsr@cee.hw.ac.uk

help cmac2d

% PROBLEM DEFINITION
%===================

% define four hundred two element input vectors.
% the first element varies between 0 and pi.
% the second element varies between -pi and pi.

rand('seed',321457);
rand('uniform')
X1 = [rand(1,300)*pi,  rand(1,100)*pi];
X2 = [rands(1,300)*pi,  zeros(1,100) ];

% define the associated four hundred one element targets.

dt = 0.05;
T= X2 + [(10*sin(X1)-2*(X2))*dt];

% scale the input data to suit the CMAC network.

X1S = (X1/pi)*128 + 64;
X2S = (X2/pi)*64 + 128;

% INITIALIZE NETWORK
%===================

iprange = 256;
width = input('enter generalisation width ');
c = input('enter number of memory locations accessed by each input, c ');
memsize = input('enter total number of memory locations (0 to disable hashing) ');
if memsize == 0
  memreq = c*ceil(iprange/width)*ceil(iprange/width);
  disp('number of weights required is');
  disp(memreq);
  wts = zeros(memreq,1);
else
  wts = zeros(memsize,1);
end

% TRAIN THE NETWORK
%==================

% TRAINING PARAMETERS

max_epoch = input('enter max number of epochs ');
beta = input('enter learning rate (0 to 2) ');
df = 5;
clear sse;

netout = zeros(1,400);
for epoch = 1:max_epoch
  for i=1:400
    netout(i) = modcmac(wts,[X1S(i);X2S(i)],T(i),beta,256,c,width,memsize);
  end
  sse(epoch) = sumsqr(T-netout);
  if rem(epoch,df) ==0
    clf reset
    semilogy(0:length(sse)-1,sse);
    xlabel('epoch')
    ylabel('sum squared error')
    title('network error')
    drawnow
  end
end

semilogy(0:length(sse)-1,sse);
xlabel('epoch');
ylabel('sum squared error');
title('network error');
