%
% EXAMPLE CMAC1D: FUNCTION APPROXIMATION
% Compare this with the example BCKPROP4 in chapter 5 of
% the Neural Network Toolbox Users Manual.
%
% A single input single output CMAC network
% is trained on a 21 pattern problem.
%
% CMAC operates as a form of lookup table. Note, however,
% that it generalises, i.e. is capable of producing outputs
% in response to inputs not previously experienced. In This
% example there are 21 training examples but the network
% is capable of producing outputs for any input values.
%

% written 13 August 1993 by Donald Reay
%
% Power Electronics Group
% Department of Computing and Electrical Engineering
% Heriot-Watt University
% Edinburgh UK
%
% e-mail dsr@cee.hw.ac.uk

help cmac1d
clf reset
pausetime = 0.1;

% PROBLEM DEFINITION
%===================

% Define twenty one 1-element input vectors.

P = -1:0.1:1;


% Define four hundred and one 1-element input vectors to graph
% function that network actually performs.
% This resolution ensures that the stepped nature of the CMAC
% network output is evident.

P3 = -1:0.005:1;

% INITIALIZE NETWORK ARCHITECTURE
%================================

iprange = 256;

width = input('enter generalisation width ');

c = input('enter number of weights to be accessed, c ');

beta = input('enter learning rate, beta ');

memreq = c*ceil(iprange/width);
s = sprintf('number of weights required is %d',memreq);
disp(s);

memsize = input('enter memsize (0 to disable hashing) ');

% INITIALISE WEIGHTS
% ==================

if memsize == 0
  wts = zeros(memreq,1);
else
  wts = zeros(memsize,1);
end

% PLOT CMAC OUTPUT AFTER ONE TRAINING EXAMPLE
% ===========================================


netout = modcmac(wts,[(2.0)*64],1.0,1.0,iprange,c,width,memsize);

for k=1:401
  op(k) = opcmac(wts,[(P3(k)+2.0)*64],iprange,c,width,memsize);
end

plot(P3,op,'r');
axis([-1.0,1.0,-2.0,2.0]);
title('CMAC output after one training example');
xlabel('Input Vector P');
ylabel('Network Output');

disp('any key to continue');

pause


% Define the associated twenty-one 1-element targets.

z = menu('select target function', ...
  'damped sinusoid', ...
  'step', ...
  'impulse');
disp('')

if z == 1
  T = [-.9602 -.5770 -.0729  .3771  .6405  .6600  .4609 ...
        .1336 -.2013 -.4344 -.5000 -.3930 -.1647  .0988 ...
        .3072  .3960  .3449  .1816 -.0312 -.2189 -.3201];
else
  if z == 2
    T = [0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1];
  else
    T = [0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0];
  end
end

% PLOT TRAINING VECTORS
%======================

plot(P,T,'+');
title('Training Vectors');
xlabel('Input Vector P');
ylabel('Target Vector T');
hold on

% PLOT INITIAL FUNCTION APPROXIMATION
% ===================================

if memsize == 0
  wts = zeros(memreq,1);
else
  wts = zeros(memsize,1);
end

for i=1:401
  op(i) = opcmac(wts,[(P3(k)+2.0)*64],iprange,c,width,memsize);
end

plot(P3,op,'m');
title('Function Approximation');
xlabel('Input Vector P');
ylabel('Target + Network -');

h = get(gca,'Children');
h = h(1);
% hold on
pause2(pausetime);

% TRAIN THE NETWORK
%==================

% TRAINING PARAMETERS
max_epoch = input('enter maximum number of training epochs ');

epoch = 1;
SSE = 1;
while (epoch < max_epoch) & (SSE > 0.02)

for i = 1:21
  netout = modcmac(wts,[(P(i)+2.0)*64],T(i),beta,iprange,c,width,memsize);
end
for k=1:401
  op(k) = opcmac(wts,[(P3(k)+2.0)*64],iprange,c,width,memsize);
end
  
 % DISPLAY PROGRESS
    for i = 1:21
      neterr(i) = T(i) - opcmac(wts,[(P(i)+2.0)*64],iprange,c,width,memsize);
    end
    SSE = sumsqr(neterr);
    fprintf('epoch = %d  SSE = %5.3f\n',epoch,SSE);
    delete(h);
    h = plot(P3,op,'m');
    drawnow
    pause2(pausetime);
epoch = epoch + 1;
    end


end

disp('any key to continue');

pause

hold off
bar(wts,'r')
title('Network Weights');
xlabel('Weight Number');
ylabel('Weight Value');
if memsize == 0
  set(gca,'xlim',[0 memreq]);
else
  set(gca,'xlim',[0 memsize]);
end
