/*
    ART_VectorView.hm
    The VectorView is a simple customView object for rough presantation
    of vectors produced by ART2 for animation.

    - simple line graph for real arrays
    - simple 2D plot of the inputarray with grayshading mag
*/

#import <appkit/appkit.h>
#import <appkit/View.h>

@interface ART_VektorView : View
{
    float *points;
    NXRect *merks;
    int numPoints,numMerks;
    float bbox[4];
    char *ops;
    float *gshades;
    float lineGray;
    float backgroundGray;
    int vec_mode;
}

- initFrame:(NXRect *)aRect;
- free;

- setVector:(int)num Vec:(float *)Vec max:(float)max;
- setPattern:(float *)Vec row:(int)row col:(int)col;
- setBar:(int)num Vec:(float *)Vec max:(float)max select:(int)s;
- scaleToFit;

- setLineGray:(float)gray;
- setBackgroundGray:(float)gray;
- (float)lineGray;
- (float)backgroundGray;

@end
