#import <objc/Object.h>
#include "ART_Func.h"

#define ART_ACT_OFF -1
#define ART_STM_SIGMO 1
#define ART_STM_GROSS 2

@interface ART_STM :Object
{
int     M;                // field dimension
float   *P,*U,*W,         // left Side
        *Q,*V,*X,         // right Side
        *old_W,*old_P,    // last Iteration state
        *I,*E;            // input at W and input at P

float   a,b,              // field constances
        d,                // learnrate 
        theta;            // parameter of the non-linear function

int     i_min,i_max,      // iteration boundings
        act_node,         // the active node of a competionen fields
        noLinFunc;        // flag for no linear function
float   Act_stable;       // activity stable criterion
NXZone *zone;
}
+ new;
- save;
- load;
- init:(int)Vec_dim;
- free;
// field initalisation
- set_a:(float)p1 b:(float)p2 theta:(float)p3 d:(float)p4;
- set_NoLinFunc:(int)f;
- set_zero;
- set_I:(float *)I_PTR and_E:(float *)E_PTR;
- setIterationmin:(int)min max:(int)max stable:(float)stable;
// access methods to the node pointer
- (float *)get_P;
- (float *)get_U;
- (float *)get_W;
- (float *)get_Q;
- (float *)get_V;
- (float *)get_X;
// care full 'cause I and E aren't allocate in the STM object
- (float *)get_I;
- (float *)get_E;
// a special set methods to the node pointer p be carefull
- set_P:(float *)Vec;


// special for competition fields
// method retrun the index of maximum of U
- (int)MaxAct_with:(int)nodes;
- (int)activeNode;

// STM Object Iteration and Performance Method
- (int)iterate;

@end





