#import <objc/Object.h>
#import "ART_Func.h"

#define ART_LTM_ASCII 0
#define ART_LTM_BIN 1

#define LTM_NODE_RESET 0
#define LTM_NODE_AVAIL 1


@interface ART_LTM : Object
{
     NXZone *zone;        // Next Heap Zone

     int   M,N;           // field dimensions
     float **BU,**TD,     // learning arrays
           *oldTD,*oldBU,
           d,h;           // learning rate and integation stepsize
     int   *Avail,        // flag array for notation of reset nodes
           estab;         // acount of established nodes
   
}

+ new;
- saveinto:(NXStream *)stream as:(int)t;
- loadfrom:(NXStream *)stream;
// init LTM array and additionals
- init:(int)M_dim of:(int)N_dim;
// free all allocated memory
- free;
// set the central parameter
- set_d:(float)learnrate h:(float)stepsize;
// give away the weights of a single F2 node
- zero_template:(int)template with:(float)BU_scale;
// give away all weights
- set_zero_with:(float)BU_scale;
// transform a pattern from F1 to F2, seems like a korrelation
- (int)korrelate_with:(float *)P to:(float *)Y;
// retrun a pointer to the TD array of M from a F2 node
- (float *)TD_of:(int)j;
// returns a pointer to the BU array of N from a F1 node
- (float *)BU_of:(int)i;
// set a vector of dim to the TD[j] array of LTM
- set:(float *)Vec of:(int)dim to_TD_of:(int)j;
// set a vector of dim to the BU[i] array of LTM
- set:(float* )Vec of:(int)dim to_BU_of:(int)i;
// declaire a Node as stable as tis norm excceds the thresh
- (BOOL)is:(int)Node stable:(float)thresh;
// methods concern the reset state of the F2 nodes
// prepare for a new input pattern
- (int)newPattern;
// reset a certain node in case of the rho mismatch
- (int)resetNode:(int)j;
// gives back to availebal flag
- (BOOL)NodeAvail:(int)i;
// returns the amount of etablished F2 nodes
- (int)estabNodes;
// set the estab var to a new value
- setestabNodes:(int)newestab;

// perform the learning facility of the LTM array
- (float)learnPattern:(float *)Learn_Vec toNode:(int)F2_on;
@end





