

#include  <stdlib.h>
#include  <math.h>
#include  "ART_Func.h"
  


 

float fgross(float x, float t)     
{
     float temp;
     if (x > t) return(x);
     else {
       temp=x*x;
       return(2*t*temp/(temp+(t*t)));
       }          
}

float sigmo(float x, float sm, float sb)
{
     float ta=1+exp((sm-x)/sb);
     return(x/ta);
}

float DotProd(float *V1,float *V2,int M)
{
      int i;
      float dp=0.0;
      for (i=0;i<M;i++)
        dp += V1[i]*V2[i];
      return (float)dp;
}

float L2_norm(float *V,int M)
{
      return(float) sqrt(DotProd(V,V,M)) ;
}

float L2_norm_Vec(float *Vec,float *normVec,int M)
{
      int i;
      float tmp=L2_norm(Vec,M);
      for (i=0;i<M;i++) normVec[i]=Vec[i]/tmp;
      return tmp;
}

float vec_diff(float *V1,float *V2,int M)
{
      int i;
      float tmp=0.0;
      for (i=0;i<M;i++)
        tmp += fabs(V1[i]-V2[i]);
      return (float)tmp;
}
