#import "ART_Animator.h"
#import "ART_VektorView.h"

#import <objc/Object.h>
#import <appkit/appkit.h>
#import <appkit/TextField.h>


/* Interface Outlets & Macro

id InVecView;
id PreVecView;
id TmpVecView;
id F0msg;
id F1msg;
id F2msg;
float *InVec;
float *PreVec;
float *TmpVec;
int row;
int col;
int dim;
float mag,z_max;
int disp_mode;
*/
int Animation_hide=0;

@implementation ART_Animator
- init
{
     [super init];
     return self;
}
- initdisplay
{
     float *Z;
     int i;
     Z=NXZoneMalloc([self zone],10*sizeof(float));
     for (i=0;i<10;i++) Z[i]=0.0;
     // initialisation
     [self setDispMode:1];
     [self setRow:2 Col:5];
     [self setDim:10 Mag:1.0 zMax:1.0];
     [self setInVec:Z];
     [self setPreVec:Z];
     [self setTmpVec:Z];
     [self showAll];
     NXZoneFree([self zone],Z);
     return self;
}

- setRow:(int)r Col:(int)c
{
     row=r;col=c;
     return self;
}
- setDim:(int)d Mag:(float)m zMax:(float)z
{
     dim=d;mag=m;z_max=z;
     return self;
}
- setInVec:(float *)Vec
{
     InVec=Vec;
     return self;
}
- setPreVec:(float *)Vec
{
     PreVec=Vec;
     return self;
}
- setTmpVec:(float *)Vec
{
     TmpVec=Vec;
     return self;
}
- setDispMode:(int)dm
{   
     disp_mode=dm;
     return self;
}
- showInVec
{
     if (Animation_hide) return self;
     if (disp_mode) {
       [InVecView setBackgroundGray:NX_WHITE];
       [InVecView setPattern:InVec row:row col:col];
       }
     else {
       [InVecView setBackgroundGray:NX_LTGRAY];
       [InVecView setVector:dim Vec:InVec max:mag];
       }
     [InVecView scaleToFit];
     [InVecView display];
     return self;
}
- showPreVec
{
     if (Animation_hide) return self;
     if (disp_mode) {
       [PreVecView setBackgroundGray:NX_WHITE];
       [PreVecView setPattern:PreVec row:row col:col];
       }
     else {
       [PreVecView setBackgroundGray:NX_LTGRAY];
       [PreVecView setVector:dim Vec:PreVec max:1.0];
       }
     [PreVecView scaleToFit];
     [PreVecView display];
     return self;
}
- showWinVec:(int)m Vec:(float *)Vec
{
     if (Animation_hide) return self;
     [TmpVecView setBackgroundGray:NX_LTGRAY];
     [TmpVecView setVector:m Vec:Vec max:z_max];
     [TmpVecView scaleToFit];
     [TmpVecView display];
     return self;
}
- showTmpVec
{
     if (Animation_hide) return self;
     if (disp_mode) {
       [TmpVecView setBackgroundGray:NX_WHITE];
       [TmpVecView setPattern:TmpVec row:row col:col];
       }
     else {
       [TmpVecView setBackgroundGray:NX_LTGRAY];
       [TmpVecView setVector:dim Vec:TmpVec max:z_max];
       }
     [TmpVecView scaleToFit];
     [TmpVecView display];
     return self;
}
- showAll
{
     if (Animation_hide) return self;
     [self showInVec];
     [self showPreVec];
     [self showTmpVec];
     return self;
}
- F0msg  
{
     return F0msg;
}
- F01msg
{
     return F01msg;
}
- F1msg  
{
     return F1msg;
}
- F2msg  
{
     return F2msg;
}
- windowDidDeminiaturize:sender;
{
     Animation_hide=0;
     return self;
}
- windowDidMiniaturize:sender;
{
     Animation_hide=1;
     return self;
}
@end


