#import "ART2_Basic.h"

#import <objc/Object.h>
#import <dpsclient/dpsNeXT.h>	// For PS and DPS function prototypes

@interface ARTDoc:Object
{
    id window;
    id view;

    id RowIn;
    id ColIn;
    id DimOut;

    id estabOut;
    id queueOut;
    id inputOut;

    id stringTable;
    char *fileName;
    id Control;
    id Pat;
    id Animator;
    id Browser;

// ART Document parameters set in the interface
    id ARTModeMtx;
    id ARTLearnMtx;
    id f_a;
    id f_b;
    id f_c;
    id f_d;
    id f_BU_inst;
    id f_min;
    id f_max;
    id f_ac_diff;
    id f_z_diff;
    id f_h;
    id f_rho;
    id f_rhoset;
    id f_theta;
    id f_codedNodes;

//  the ART id
    id ARTModul;

// for the animation mode
    DPSTimedEntry ARTTimedEntry;

//  structure of the ARTModul for direct access
    struct ARTModulDefs {
      @defs(ART2_Basic)
      } *artp;
    int PatRow;
    int PatCol;
    int PatDim;
    int PatNum;
    int F2_on;
    int *SearchArray;
    char buf[256];
    int go_flag;
    int disp_flag;
}

- init;
- free;
- initFromFile:(const char *)file;
- setFileName:(char *)aName;
- (char *)fileName;

- setRow:sender;
- setCol:sender;
- setVecModus:sender;
- setPatModus:sender;

- save:sender;
- creatLTMdat:sender;
- setDelegate:anObject;
- (BOOL)isPerforming;
- step:sender;
- set_go;
- set_stop;
- stepPattern;
- finishCycle;

- ARTState;
- animate;
- setSearchArray;
- (BOOL)noSearch;
- setAnimator;

- resetLTM:sender;
// check method responds to the controller
- (BOOL)matchWithPat;

// comunication
- (int)inputPattern;
- (int)codesNodes;
- (int *)PatQueue;
- (int)F2Nodes;
- (float *)theTemplate:(int)i;

// method by the window who's delegate is the ARTDoc
- windowDidBecomeMain:sender;
- windowDidResignMain:sender;
- windowDidMiniaturize:sender;
- windowWillClose:sender;

- updateARTDefs; // from the display and set the ARTModul
- getARTDefs; // from the ARTModul and show
@end