// Basic ART2 Object provides compressed acces routines
// and system parameter

#import  <objc/Object.h>
#import  "ART_STM.h"
#import  "ART_LTM.h"
#include "ART_Func.h"

@interface ART2_Basic : Object
{

// strong typed Objects to be instantiate by the ART2 Modul
ART_STM *F0;    // preprocessing Field (standart ART2)
ART_STM *F1;    // F1 Field (standart ART2)
ART_STM *F2;    // F2 Field (standart ART2)
ART_STM *F0x;   // preprocessing Field for EXOR (extended ART2)
ART_LTM *LTM;   // LTM array of weights

ART_LTM *tmpLTM; // Buffer pointer for rezize LTM
ART_STM *tmpF2;  // Buffer pointer for rezize F2

float   *zeroP,*R,        // zero pattern dummy and R
        *InPat;           // pointer to the input pattern

int     M,N,              // M nodes of F0,F1 (i) and N nodes of F2 (j)
        *PatQueue;        // Output array of identifyed patterns

                          // configuration parameter
float   rho,              // standart ART2 rho
        rhoset,           // extended exor rho for real super/subsets
        tmprho,           // acutal rho for matching
        r,                // calculated rho for the actual pattern
        theta,            // function parameter
        c,d,h,            // constants of the system
        a,b,              // field constants (standart Art)
        ac_diff,z_diff,   // stability thresh of activity and weights
        BU_inst,          // BU scale for initialisation
        exor_thresh,      // threshold for learning EXOR Pattern
        sigmoWidth;       // parameter for the sigmoid threshold function

int     i_min,i_max,      // iteration boundings
        art2_mode,        // flag for performace mode
        learn_mode,       // kind of learning to be performed
        set_type;         // identifier for mix,sub or super set
}

#define ART_STABLE_LERANING 1
#define ART_ONE_LEARNING 0
#define ART_STD_MODE 0
#define ART_EXT_MODE 1
#define ART_F2_OFF -1
#define ART_MIX 0
#define ART_SUB 1
#define ART_SUP 2
#define ART_IDE 3


+ new;
- saveinto:(NXStream *)stream;
- loadfrom:(NXStream *)stream;
- init_M:(int)Vec_dim N:(int)F2_dim;
- free;
- build_ART2;
- (BOOL)resizeART;

- setdefault_config;
- update_syspara;

- zeroSTMs;
- resetLTM;

- (float)significance_of:(float *)V;

// set the input pattern and initialize the STM's
- setPattern:(float *)In;

// preprocessing returning the iterations of F0
- (int)preproc;

// chooseF2 with no template i.e. F2 has no activity
- (int)chooseF2;

// perform F1 with the preprocessed an it's tempate
-  compair;

// boolean for goood match
- (BOOL)match;

// perform learning with the stable criterion as return
- (float)learning;

// in case of an uncomitted node YES
- (BOOL)newNode;

// regitering of a template
- markActiveNode;

// perform the magic exor processing returns the type of set
- (int)exorproc;

// direct access methods
- F0;
- F1; 
- F2; 
- F0x;  
- LTM;
@end