#!/usr/bin/env python3

import numpy as np
import numpy.random as npr

import matplotlib as mpl
mpl.use('Agg')
import matplotlib.pyplot as plt
plt.style.use('bmh')

from matplotlib import gridspec

def main():
    npr.seed(0)
    for sigma in [0.1, 1.0, 10.0]:
        for x0 in [-2, 2]:
            p = lambda x: np.exp(-x*x) + 1.3*np.exp(-(x-2)**2)
            q = lambda sample, mean: (1./np.sqrt(2.*np.pi*sigma*sigma))*\
                np.exp((-(sample-mean)**2)/(2*sigma*sigma))
            sample_q = lambda mean: npr.normal(loc=mean, scale=sigma)
            xts = mh(p, q, sample_q, x0, nSamples=2000)
            plotMH(p, xts, 'mh.x0:{}.sigma:{}.png'.format(x0, sigma))

def mh(p, q, sample_q, x0, nSamples):
    """
    Input:
      + p (function) is the (possibly unnormalized) true distribution PDF.
      + q (function) is the (possibly unnormalized) sampling distribution PDF.
      + sample_q (function) samples from q.
      + x0 (scalar) is the initial point.
      + nSamples is the number of samples to generate.
    """
    xt = x0
    xts = []
    for t in range(nSamples):
        # [TODO: Your implementation here]
        # TODO: Assign into xt
        xts.append(xt)
    return xts

def plotMH(p, xts, fname):
    fig, (ax1, ax2, ax3, ax4) = plt.subplots(4, figsize=(6,10), sharex=True)
    fig.suptitle(fname)

    ax1.set_ylabel('Unnormalized Prob')
    x = np.arange(-2, 4, 0.1)
    y = [p(xi) for xi in x]
    ax1.plot(x, y)

    ax2.set_ylabel('Sample Number')
    xts_ = xts[:100]
    ax2.plot(xts_, range(len(xts_)))
    ax2.invert_yaxis()

    ax3.set_ylabel('Sample Number')
    ax3.plot(xts, range(len(xts)))
    ax3.invert_yaxis()

    ax4.set_ylabel('Histogram')
    ax4.hist(xts, 25, normed=1, alpha=0.75)

    fig.tight_layout()
    plt.savefig(fname)
    print('Created {}'.format(fname))

if __name__=='__main__':
    main()
