import numpy as np
import sys
import time
import timeit
import simplex as s


def run_test_single(test_id, simplex_method, two_phase = False):
    data=np.load('test_cases/test{0}.npz'.format(test_id))
    I,I_dual,A,b,c,f,x = data['I'], data['I_dual'], data['A'], data['b'], data['c'], data['f'], data['x']

    if two_phase:
        f1,x1 = simplex_method(c, A, b)
    else:
        f1,x1 = simplex_method(I, c, A, b)

    if np.linalg.norm(x1 - x) < 1e-10:
        print("Passed test case {0}".format(test_id))
    else:
        print("Failed test case {0}".format(test_id))

if len(sys.argv) == 1:
    print("\n\n\tSelect method to test with:")
    print("\tpython test.py test")
    print("\twhere test can be: simplex or two_phase_simplex\n\n")

elif sys.argv[1] == 'simplex':
    print("Simplex method: ")
    for t in range(0,30):
        run_test_single(t, s.simplex)

elif sys.argv[1] == 'two_phase_simplex':
    print("Two Phase Simplex method: ")
    for t in range(0,30):
        run_test_single(t, s.two_phase_simplex, True)

