#!/usr/bin/env python3

import numpy as np
import cvxpy as cp

def main():

    # This is a sample main function that shows examples and expected
    # outputs of calling the simplex and solve_sudoku functions.
    #
    # It is called in the conditional at the bottom if this file
    # is the main file your interpreter is running on and it is
    # not called when this file is used as a module for our grading.
    # You do not have to delete this function before submitting
    # the file for grading.

    sudoku_puzzle = [[8, 5, 9, 6, 1, 2, 4, 3, 7],
            [7, 2, 0, 8, 5, 4, 1, 6, 9],
            [1, 6, 4, 3, 7, 9, 5, 2, 8],
            [9, 8, 6, 1, 4, 7, 3, 5, 2],
            [3, 7, 5, 2, 6, 8, 9, 1, 4],
            [2, 4, 1, 5, 9, 0, 7, 8, 6],
            [4, 3, 2, 9, 8, 1, 6, 7, 5],
            [6, 1, 7, 0, 2, 5, 8, 9, 3],
            [5, 9, 8, 7, 3, 6, 2, 4, 1]]

    sudoku_sol = [[8, 5, 9, 6, 1, 2, 4, 3, 7],
            [7, 2, 3, 8, 5, 4, 1, 6, 9],
            [1, 6, 4, 3, 7, 9, 5, 2, 8],
            [9, 8, 6, 1, 4, 7, 3, 5, 2],
            [3, 7, 5, 2, 6, 8, 9, 1, 4],
            [2, 4, 1, 5, 9, 3, 7, 8, 6],
            [4, 3, 2, 9, 8, 1, 6, 7, 5],
            [6, 1, 7, 4, 2, 5, 8, 9, 3],
            [5, 9, 8, 7, 3, 6, 2, 4, 1]]

    print('=== solve_sudoku')
    print(' + Expected value: {}'.format((sudoku_sol, [])))
    print(' +     Your value: {}'.format(solve_sudoku(sudoku_puzzle)))

    sudoku_puzzle = [[8, 5, 0, 0, 0, 2, 4, 0, 0],
            [7, 2, 0, 0, 0, 0, 0, 0, 9],
            [0, 0, 4, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 1, 0, 7, 0, 0, 2],
            [3, 0, 5, 0, 0, 0, 9, 0, 0],
            [0, 4, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 8, 0, 0, 7, 0],
            [0, 1, 7, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 3, 6, 0, 4, 0]]

    sudoku_sol = [[8, 5, 9, 6, 1, 2, 4, 3, 7],
            [7, 2, 3, 8, 5, 4, 1, 6, 9],
            [1, 6, 4, 3, 7, 9, 5, 2, 8],
            [9, 8, 6, 1, 4, 7, 3, 5, 2],
            [3, 7, 5, 2, 6, 8, 9, 1, 4],
            [2, 4, 1, 5, 9, 3, 7, 8, 6],
            [4, 3, 2, 9, 8, 1, 6, 7, 5],
            [6, 1, 7, 4, 2, 5, 8, 9, 3],
            [5, 9, 8, 7, 3, 6, 2, 4, 1]]

    print('=== solve_sudoku')
    print(' + Expected value: {}'.format((sudoku_sol, [])))
    print(' +     Your value: {}'.format(solve_sudoku(sudoku_puzzle)))

    sudoku_puzzle = [[4, 8, 0, 3, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 7, 1],
            [0, 2, 0, 0, 0, 0, 0, 0, 0],
            [7, 0, 5, 0, 0, 0, 0, 6, 0],
            [0, 0, 0, 2, 0, 0, 8, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 1, 0, 7, 6, 0, 0, 0],
            [3, 0, 0, 0, 0, 0, 4, 0, 0],
            [0, 0, 0, 0, 5, 0, 0, 0, 0]]

    sudoku_sol = [[4, 8, 7, 3, 1, 2, 6, 9, 5],
            [5, 9, 3, 6, 8, 4, 2, 7, 1],
            [1, 2, 6, 5, 9, 7, 3, 8, 4],
            [7, 3, 5, 8, 4, 9, 1, 6, 2],
            [9, 1, 4, 2, 6, 5, 8, 3, 7],
            [2, 6, 8, 7, 3, 1, 5, 4, 9],
            [8, 5, 1, 4, 7, 6, 9, 2, 3],
            [3, 7, 9, 1, 2, 8, 4, 5, 6],
            [6, 4, 2, 9, 5, 3, 7, 1, 8]]

    print('=== solve_sudoku')
    print(' + Expected value: {}'.format((sudoku_sol, [(6, 3, 2, 0)])))
    print(' +     Your value: {}'.format(solve_sudoku(sudoku_puzzle)))

##########################################################
# INPUT description:
# Your algorithms receive one input:
# puzzle <- a Sudoku puzzle as a 9x9 "list of lists" of integers,
#           where zeros represent missing entries that must be
#           assigned by your algorithm, and all other integers
#           represent a known assignment, i.e.,
#           [[4, 8, 0, 3, 0, 0, 0, 0, 0],
#            [0, 0, 0, 0, 0, 0, 0, 7, 1],
#            [0, 2, 0, 0, 0, 0, 0, 0, 0],
#            [7, 0, 5, 0, 0, 0, 0, 6, 0],
#            [0, 0, 0, 2, 0, 0, 8, 0, 0],
#            [0, 0, 0, 0, 0, 0, 0, 0, 0],
#            [0, 0, 1, 0, 7, 6, 0, 0, 0],
#            [3, 0, 0, 0, 0, 0, 4, 0, 0],
#            [0, 0, 0, 0, 5, 0, 0, 0, 0]]
#
# OUTPUT description:
# You algorithms should return two things:
# 1. solved_puzzle
#     - the input puzzle with all the zeros assigned to their
#       correct values. For example, for the example puzzle,
#       your implement should return
#       [[4, 8, 7, 3, 1, 2, 6, 9, 5],
#        [5, 9, 3, 6, 8, 4, 2, 7, 1],
#        [1, 2, 6, 5, 9, 7, 3, 8, 4],
#        [7, 3, 5, 8, 4, 9, 1, 6, 2],
#        [9, 1, 4, 2, 6, 5, 8, 3, 7],
#        [2, 6, 8, 7, 3, 1, 5, 4, 9],
#        [8, 5, 1, 4, 7, 6, 9, 2, 3],
#        [3, 7, 9, 1, 2, 8, 4, 5, 6],
#        [6, 4, 2, 9, 5, 3, 7, 1, 8]]
#
# 2. constraints
#     - constraints with which the Sudoku linear program gives
#       the solution with integer values. For example,
#       constraints = [(8, 5, 2, 1), (5, 3, 4, 1)] implies that
#       if we augment the Sudoku linear program with the constraints
#       (z_{8,5})_{2} = 1 and (z_{5,3})_{4} = 1, then the solution
#       will have integer values and give the solution above.
#       See the description of Homework 1 for more details.
#
# return them with the statement: return (solved_puzzle, constraints)
##########################################################

##########################################################
# Implement the sudoku solver here.
##########################################################
def solve_sudoku(puzzle):
    pass # write your implementation here

if __name__=='__main__':
    main()