/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

public final class Painter {
    private static final int native_size = 75;
    private static final int[][] pawnOutlineNative = new int[][]{{13, 63}, {13, 54}, {18, 46}, {30, 39}, {25, 35}, {25, 27}, {29, 23}, {32, 22}, {29, 18}, {29, 13}, {33, 9}, {36, 8}, {39, 8}, {42, 9}, {46, 13}, {46, 18}, {43, 22}, {46, 23}, {50, 27}, {50, 35}, {45, 39}, {57, 46}, {62, 54}, {62, 63}, {13, 63}};
    private static final int[][] rookOutlineNative = new int[][]{{11, 69}, {11, 65}, {22, 54}, {22, 24}, {15, 17}, {15, 6}, {25, 6}, {25, 12}, {32, 12}, {32, 6}, {43, 6}, {43, 12}, {50, 12}, {50, 6}, {60, 6}, {60, 17}, {53, 24}, {53, 54}, {64, 65}, {64, 69}, {11, 69}};
    private static final int[][] rookHighlightNative = new int[][]{{22, 54}, {22, 24}, {53, 24}, {53, 54}, {22, 54}};
    private static final int[][] knightOutlineNative = new int[][]{{21, 69}, {68, 69}, {68, 55}, {62, 29}, {53, 19}, {43, 14}, {37, 6}, {35, 6}, {36, 14}, {28, 6}, {26, 6}, {29, 14}, {25, 13}, {18, 19}, {5, 46}, {12, 54}, {20, 46}, {15, 53}, {17, 55}, {34, 40}, {37, 45}, {21, 62}, {21, 69}};
    private static final int[][] knightManeNative = new int[][]{{64, 65}, {57, 31}, {45, 20}, {42, 20}, {54, 31}, {61, 65}, {64, 65}};
    private static final int[][] knightEyeNative = new int[][]{{19, 29}, {23, 26}, {24, 22}, {20, 25}, {19, 29}};
    private static final int[][] knightNoseNative = new int[][]{{8, 46}, {10, 48}, {13, 43}, {11, 41}, {8, 46}};
    private static final int[][] bishopOutlineNative = new int[][]{{6, 71}, {9, 65}, {28, 65}, {22, 38}, {22, 29}, {24, 25}, {30, 19}, {35, 15}, {33, 10}, {35, 6}, {40, 6}, {42, 10}, {40, 15}, {45, 19}, {51, 25}, {53, 29}, {53, 38}, {47, 65}, {66, 65}, {69, 71}, {6, 71}};
    private static final int[][] bishopCrossNative = new int[][]{{36, 28}, {36, 31}, {33, 31}, {33, 34}, {36, 34}, {36, 40}, {39, 40}, {39, 34}, {42, 34}, {42, 31}, {39, 31}, {39, 28}, {36, 28}};
    private static final int[][] bishopBandNative = new int[][]{{27, 60}, {35, 59}, {40, 59}, {48, 60}, {50, 51}, {41, 50}, {34, 50}, {25, 51}, {27, 60}};
    private static final int[][] queenOutlineNative = new int[][]{{27, 69}, {17, 68}, {17, 62}, {16, 52}, {8, 22}, {5, 19}, {5, 15}, {8, 12}, {12, 12}, {15, 15}, {15, 19}, {12, 22}, {22, 39}, {26, 16}, {23, 13}, {23, 9}, {26, 6}, {30, 6}, {33, 9}, {33, 13}, {30, 16}, {37, 35}, {38, 35}, {45, 16}, {42, 13}, {42, 9}, {45, 6}, {49, 6}, {52, 9}, {52, 13}, {49, 16}, {53, 39}, {63, 22}, {60, 19}, {60, 15}, {63, 12}, {67, 12}, {70, 15}, {70, 19}, {67, 22}, {59, 52}, {58, 62}, {58, 68}, {48, 69}, {27, 69}};
    private static final int[][] queenBandNative = new int[][]{{29, 60}, {17, 62}, {16, 52}, {29, 50}, {46, 50}, {59, 52}, {58, 62}, {46, 60}, {29, 60}};
    private static final int[][] kingOutlineNative = new int[][]{{27, 69}, {21, 66}, {16, 47}, {11, 45}, {6, 40}, {4, 35}, {4, 32}, {6, 27}, {11, 22}, {16, 20}, {19, 20}, {24, 22}, {28, 26}, {30, 26}, {30, 23}, {36, 17}, {36, 13}, {33, 13}, {33, 10}, {36, 10}, {36, 6}, {39, 6}, {39, 10}, {42, 10}, {42, 13}, {39, 13}, {39, 17}, {45, 23}, {45, 26}, {47, 26}, {51, 22}, {56, 20}, {59, 20}, {64, 22}, {69, 27}, {71, 32}, {71, 35}, {69, 40}, {64, 45}, {59, 47}, {54, 66}, {48, 69}, {27, 69}};
    private static final int[][] kingJewelNative = new int[][]{{36, 23}, {34, 27}, {36, 31}, {39, 31}, {41, 27}, {39, 23}, {36, 23}};
    private static final int[][] kingLeftLobeNative = new int[][]{{15, 25}, {21, 25}, {34, 38}, {34, 44}, {20, 45}, {15, 42}, {10, 36}, {10, 31}, {15, 25}};
    private static final int[][] kingRightLobeNative = new int[][]{{60, 25}, {54, 25}, {41, 38}, {41, 44}, {55, 45}, {60, 42}, {65, 36}, {65, 31}, {60, 25}};
    private static final int[][] kingBandNative = new int[][]{{19, 57}, {33, 54}, {42, 54}, {56, 57}, {54, 63}, {40, 60}, {35, 60}, {21, 63}, {18, 57}};
    private int[][] bishopBand = new int[bishopBandNative.length][2];
    private int[][] bishopCross = new int[bishopCrossNative.length][2];
    private int[][] bishopOutline = new int[bishopOutlineNative.length][2];
    private int[][] kingBand = new int[kingBandNative.length][2];
    private int[][] kingJewel = new int[kingJewelNative.length][2];
    private int[][] kingLeftLobe = new int[kingLeftLobeNative.length][2];
    private int[][] kingOutline = new int[kingOutlineNative.length][2];
    private int[][] kingRightLobe = new int[kingRightLobeNative.length][2];
    private int[][] knightEye = new int[knightEyeNative.length][2];
    private int[][] knightMane = new int[knightManeNative.length][2];
    private int[][] knightNose = new int[knightNoseNative.length][2];
    private int[][] knightOutline = new int[knightOutlineNative.length][2];
    private int[][] pawnOutline = new int[pawnOutlineNative.length][2];
    private int[][] queenBand = new int[queenBandNative.length][2];
    private int[][] queenOutline = new int[queenOutlineNative.length][2];
    private int[][] rookHighlight = new int[rookHighlightNative.length][2];
    private int[][] rookOutline = new int[rookOutlineNative.length][2];
    private int current_scale = 75;

    public Painter() {
        this.copy(bishopBandNative, this.bishopBand);
        this.copy(bishopCrossNative, this.bishopCross);
        this.copy(bishopOutlineNative, this.bishopOutline);
        this.copy(kingBandNative, this.kingBand);
        this.copy(kingJewelNative, this.kingJewel);
        this.copy(kingLeftLobeNative, this.kingLeftLobe);
        this.copy(kingOutlineNative, this.kingOutline);
        this.copy(kingRightLobeNative, this.kingRightLobe);
        this.copy(knightEyeNative, this.knightEye);
        this.copy(knightManeNative, this.knightMane);
        this.copy(knightNoseNative, this.knightNose);
        this.copy(knightOutlineNative, this.knightOutline);
        this.copy(pawnOutlineNative, this.pawnOutline);
        this.copy(queenBandNative, this.queenBand);
        this.copy(queenOutlineNative, this.queenOutline);
        this.copy(rookHighlightNative, this.rookHighlight);
        this.copy(rookOutlineNative, this.rookOutline);
    }

    private void copy(int[][] src, int[][] dest) {
        int i = 0;
        while (i < src.length) {
            dest[i][0] = src[i][0];
            dest[i][1] = src[i][1];
            ++i;
        }
    }

    public void drawPawn(Graphics g, Color piece, Color outline, int scale, int x, int y) {
        this.drawScaledPoly(g, piece, outline, scale, x, y, this.pawnOutline);
    }

    public void drawRook(Graphics g, Color piece, Color outline, int scale, int x, int y) {
        this.drawScaledPoly(g, piece, outline, scale, x, y, this.rookOutline);
        this.drawScaledPoly(g, piece, outline, scale, x, y, this.rookHighlight);
    }

    public void drawKnight(Graphics g, Color piece, Color outline, int scale, int x, int y) {
        this.drawScaledPoly(g, piece, outline, scale, x, y, this.knightOutline);
        this.drawScaledPoly(g, piece, outline, scale, x, y, this.knightMane);
        this.drawScaledPoly(g, piece, outline, scale, x, y, this.knightEye);
        this.drawScaledPoly(g, piece, outline, scale, x, y, this.knightNose);
    }

    public void drawBishop(Graphics g, Color piece, Color outline, int scale, int x, int y) {
        this.drawScaledPoly(g, piece, outline, scale, x, y, this.bishopOutline);
        this.drawScaledPoly(g, piece, outline, scale, x, y, this.bishopCross);
        this.drawScaledPoly(g, piece, outline, scale, x, y, this.bishopBand);
    }

    public void drawQueen(Graphics g, Color piece, Color outline, int scale, int x, int y) {
        this.drawScaledPoly(g, piece, outline, scale, x, y, this.queenOutline);
        this.drawScaledPoly(g, piece, outline, scale, x, y, this.queenBand);
    }

    public void drawKing(Graphics g, Color piece, Color outline, int scale, int x, int y) {
        this.drawScaledPoly(g, piece, outline, scale, x, y, this.kingOutline);
        this.drawScaledPoly(g, piece, outline, scale, x, y, this.kingJewel);
        this.drawScaledPoly(g, piece, outline, scale, x, y, this.kingLeftLobe);
        this.drawScaledPoly(g, piece, outline, scale, x, y, this.kingRightLobe);
        this.drawScaledPoly(g, piece, outline, scale, x, y, this.kingBand);
    }

    public void rescalePolygons(int newsize) {
        double factor = (double)newsize / 75.0;
        Painter.rescalePolygon(pawnOutlineNative, this.pawnOutline, factor);
        Painter.rescalePolygon(rookOutlineNative, this.rookOutline, factor);
        Painter.rescalePolygon(rookHighlightNative, this.rookHighlight, factor);
        Painter.rescalePolygon(knightOutlineNative, this.knightOutline, factor);
        Painter.rescalePolygon(knightManeNative, this.knightMane, factor);
        Painter.rescalePolygon(knightEyeNative, this.knightEye, factor);
        Painter.rescalePolygon(knightNoseNative, this.knightNose, factor);
        Painter.rescalePolygon(bishopOutlineNative, this.bishopOutline, factor);
        Painter.rescalePolygon(bishopCrossNative, this.bishopCross, factor);
        Painter.rescalePolygon(bishopBandNative, this.bishopBand, factor);
        Painter.rescalePolygon(queenOutlineNative, this.queenOutline, factor);
        Painter.rescalePolygon(queenBandNative, this.queenBand, factor);
        Painter.rescalePolygon(kingOutlineNative, this.kingOutline, factor);
        Painter.rescalePolygon(kingJewelNative, this.kingJewel, factor);
        Painter.rescalePolygon(kingLeftLobeNative, this.kingLeftLobe, factor);
        Painter.rescalePolygon(kingRightLobeNative, this.kingRightLobe, factor);
        Painter.rescalePolygon(kingBandNative, this.kingBand, factor);
        this.current_scale = newsize;
    }

    public static void rescalePolygon(int[][] nativepoly, int[][] poly, double factor) {
        int i = 0;
        while (i < poly.length) {
            poly[i][0] = (int)(factor * (double)nativepoly[i][0]);
            poly[i][1] = (int)(factor * (double)nativepoly[i][1]);
            ++i;
        }
    }

    public void drawScaledPoly(Graphics g, Color fill, Color outline, int size, int x, int y, int[][] src) {
        if (size != this.current_scale) {
            this.rescalePolygons(size);
        }
        int[] xp = new int[src.length];
        int[] yp = new int[src.length];
        int i = 0;
        while (i < src.length) {
            xp[i] = x + src[i][0];
            yp[i] = y + src[i][1];
            ++i;
        }
        g.setColor(fill);
        g.fillPolygon(xp, yp, src.length);
        g.setColor(outline);
        g.drawPolygon(xp, yp, src.length);
    }

    public void drawPiece(Graphics g, char piece, int scale, int x, int y) {
        Color outlinecolor;
        Color piececolor;
        if (piece == '-') {
            return;
        }
        if (Board.isWhite(piece)) {
            piececolor = Config.colorWhitePiece;
            outlinecolor = Config.colorWhiteOutline;
        } else {
            piececolor = Config.colorBlackPiece;
            outlinecolor = Config.colorBlackOutline;
        }
        switch (piece) {
            case 'P': 
            case 'p': {
                this.drawPawn(g, piececolor, outlinecolor, scale, x, y);
                break;
            }
            case 'R': 
            case 'r': {
                this.drawRook(g, piececolor, outlinecolor, scale, x, y);
                break;
            }
            case 'N': 
            case 'n': {
                this.drawKnight(g, piececolor, outlinecolor, scale, x, y);
                break;
            }
            case 'B': 
            case 'b': {
                this.drawBishop(g, piececolor, outlinecolor, scale, x, y);
                break;
            }
            case 'Q': 
            case 'q': {
                this.drawQueen(g, piececolor, outlinecolor, scale, x, y);
                break;
            }
            case 'K': 
            case 'k': {
                this.drawKing(g, piececolor, outlinecolor, scale, x, y);
                break;
            }
            default: {
                System.out.println("drawPiece: unknown piece:" + piece);
            }
        }
    }
}

