/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class MultiLineLabel
extends Canvas {
    protected String text;
    protected String[] lines;
    protected int num_lines;
    protected int line_height;
    protected int line_ascent;
    protected int[] line_widths;
    protected int max_width;
    protected final int margin_width = 2;
    protected final int margin_height = 2;

    protected void newLabel(String label) {
        this.text = label;
        StringTokenizer t = new StringTokenizer(label, "\n");
        this.num_lines = t.countTokens();
        this.lines = new String[this.num_lines];
        this.line_widths = new int[this.num_lines];
        int i = 0;
        while (i < this.num_lines) {
            this.lines[i] = t.nextToken();
            ++i;
        }
    }

    protected void setText(String t) {
        this.newLabel(t);
        this.measure();
        this.repaint();
    }

    protected String getText() {
        return this.text;
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.measure();
    }

    protected void measure() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm == null) {
            return;
        }
        this.line_height = fm.getHeight();
        this.line_ascent = fm.getAscent();
        this.max_width = 0;
        int i = 0;
        while (i < this.num_lines) {
            this.line_widths[i] = fm.stringWidth(this.lines[i]);
            if (this.line_widths[i] > this.max_width) {
                this.max_width = this.line_widths[i];
            }
            ++i;
        }
    }

    public MultiLineLabel(String label) {
        this.newLabel(label);
    }

    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    public Dimension preferredSize() {
        return new Dimension(this.max_width + 4, this.num_lines * this.line_height + 4);
    }

    public Dimension minimumSize() {
        return new Dimension(this.max_width, this.num_lines * this.line_height);
    }

    public void paint(Graphics g) {
        Dimension d = this.size();
        int y = this.line_ascent + (d.height - this.num_lines * this.line_height) / 2;
        int x = 2;
        int i = 0;
        while (i < this.num_lines) {
            g.drawString(this.lines[i], x, y);
            ++i;
            y += this.line_height;
        }
    }
}

