/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.util.StringTokenizer;

public final class MessagePanel
extends Panel {
    private Hub hub;
    private TextArea taMessage;
    private TextArea taChat;
    private TextField tfCommand;
    private CheckboxGroup cbgTalk;
    private Checkbox cbTalkAll;
    private Checkbox cbTalkOpp;
    private Checkbox cbCommand;
    private Label labelSay;
    private static final int nTextBufferLength = 5000;
    private static final int nTextBufferDecrement = 1000;
    private boolean commandEnabled = true;
    private int sizeWidth = 0;
    private int sizeColumns = 79;

    public MessagePanel(Hub mhub) {
        this.hub = mhub;
        this.setBackground(Config.colorMessage);
        this.taMessage = new TextArea(8, 20);
        this.taMessage.setEditable(false);
        this.tfCommand = new TextField();
        this.cbgTalk = new CheckboxGroup();
        this.cbTalkAll = new Checkbox("Chat", this.cbgTalk, false);
        this.cbTalkOpp = new Checkbox("Talk to opponent", this.cbgTalk, false);
        if (this.commandEnabled) {
            this.cbCommand = new Checkbox("Command", this.cbgTalk, true);
        }
        Font textfont = new Font("Courier", 0, 12);
        Font labelfont = new Font("Dialog", 1, 12);
        this.taMessage.setFont(textfont);
        this.tfCommand.setFont(textfont);
        this.tfCommand.setBackground(Config.colorCommandArea);
        this.tfCommand.setForeground(Config.colorCommandText);
        int slop = this.commandEnabled ? 1 : 0;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gridbag);
        gbc.gridheight = 1;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 4 + slop;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gridbag.setConstraints(this.taMessage, gbc);
        this.add(this.taMessage);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        this.labelSay = new Label("Chat:");
        this.labelSay.setFont(labelfont);
        gridbag.setConstraints(this.labelSay, gbc);
        this.add(this.labelSay);
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gridbag.setConstraints(this.tfCommand, gbc);
        this.add(this.tfCommand);
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gridbag.setConstraints(this.cbTalkAll, gbc);
        this.add(this.cbTalkAll);
        gbc.gridx = 3;
        gridbag.setConstraints(this.cbTalkOpp, gbc);
        this.add(this.cbTalkOpp);
        if (this.commandEnabled) {
            gbc.gridx = 4;
            gridbag.setConstraints(this.cbCommand, gbc);
            this.add(this.cbCommand);
        }
    }

    private int getColumns() {
        int w = this.taMessage.size().width;
        if (w == this.sizeWidth) {
            return this.sizeColumns;
        }
        FontMetrics fm = this.taMessage.getFontMetrics(this.taMessage.getFont());
        if (fm == null) {
            return this.sizeColumns;
        }
        this.sizeWidth = w;
        int tempColumns = (w - 25) / fm.charWidth(' ');
        if (tempColumns != this.sizeColumns) {
            this.sizeColumns = tempColumns;
            this.hub.sendCommand("set-quietly width " + this.sizeColumns);
        }
        return this.sizeColumns;
    }

    private String chop(String s) {
        int cols = this.getColumns();
        StringTokenizer st = new StringTokenizer(s, "\n\r");
        String retval = "";
        while (st.hasMoreTokens()) {
            retval = "\n" + retval + MessagePanel.chopLine(st.nextToken(), cols);
        }
        return retval;
    }

    private static String chopLine(String line, int cols) {
        String retval = "";
        while (line.length() > cols) {
            int pos = line.lastIndexOf(32, cols);
            if (pos < 3) {
                retval = String.valueOf(retval) + line.substring(0, cols) + '\n';
                line = " " + line.substring(cols);
                continue;
            }
            retval = String.valueOf(retval) + line.substring(0, pos) + '\n';
            line = "  " + line.substring(pos);
        }
        retval = String.valueOf(retval) + line;
        return retval;
    }

    public void addMessage(String s) {
        if (this.taMessage.getText().length() > 5000) {
            this.taMessage.replaceText("", 0, 1000);
        }
        this.taMessage.appendText(this.chop(s));
    }

    public void addChat(String s) {
        this.addMessage(s);
    }

    public void receiveL2(L2Item item) {
        switch (item.getCode()) {
            case 31: {
                this.addMessage(String.valueOf(item.getString(1)) + ": " + item.getString(3) + "\n");
                break;
            }
            case 28: {
                this.addChat(String.valueOf(item.getString(2)) + "(" + item.getInt(1) + "): " + item.getString(4) + "\n");
                break;
            }
            default: {
                this.hub.addMessage("Error in MessagePanel: Received L2 " + item.getCode());
            }
        }
    }

    public boolean action(Event evt, Object what) {
        if (evt.target == this.tfCommand) {
            String s = (String)what;
            if (s == null || s.length() == 0) {
                return true;
            }
            this.issueCommand(s);
            return true;
        }
        if (evt.target == this.cbCommand && ((Boolean)what).booleanValue()) {
            this.labelSay.setText("Do:  ");
        } else if (evt.target == this.cbTalkAll && ((Boolean)what).booleanValue()) {
            this.labelSay.setText("Chat:");
        } else if (evt.target == this.cbTalkOpp && ((Boolean)what).booleanValue()) {
            this.labelSay.setText("Say: ");
        }
        return super.action(evt, what);
    }

    private void issueCommand(String s) {
        if (this.cbTalkAll.getState()) {
            this.hub.sendCommandAndEcho("tell 50 " + s);
        } else if (this.cbTalkOpp.getState()) {
            this.hub.sendCommandAndEcho("say " + s);
        } else {
            this.hub.sendCommandAndEcho(s);
        }
        this.tfCommand.setText("");
    }

    public boolean handleKeypress(Event evt) {
        if (evt.id == 401 && evt.target != this.tfCommand) {
            char key = (char)evt.key;
            switch (key) {
                case '\n': 
                case '\r': {
                    this.issueCommand(this.tfCommand.getText());
                    break;
                }
                case '\b': {
                    String s = this.tfCommand.getText();
                    if (s.length() <= 0) break;
                    this.tfCommand.setText(s.substring(0, s.length() - 1));
                    break;
                }
                default: {
                    if (key < ' ') break;
                    this.tfCommand.setText(String.valueOf(this.tfCommand.getText()) + key);
                }
            }
            return true;
        }
        return false;
    }

    public void giveFocus() {
        this.tfCommand.requestFocus();
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        return new Dimension(40, this.taMessage.preferredSize().height + this.tfCommand.preferredSize().height);
    }

    public void shutdown() {
        this.taMessage.setText("");
    }

    public void paint(Graphics g) {
        this.getColumns();
        super.paint(g);
    }
}

