/*
 * Decompiled with CFR 0.152.
 */
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;

public final class IccInputStream
extends FilterInputStream
implements Runnable {
    private Hub mhub;
    private Iconn connection;
    private Encryptor receive_encryptor;
    private boolean decrypting = true;
    private boolean got_eof;
    private final int SBUF_initial_size = 400;
    private final int BELL_byte = 7;
    private final int MARK_byte = 25;
    private final int L1_open_byte = 91;
    private final int L1_close_byte = 93;
    private final int L2_open_byte = 40;
    private final int L2_close_byte = 41;
    private final int QUOTE_open_byte = 123;
    private final int QUOTE_close_byte = 125;
    public static final int FIRST_non_char = 256;
    public static final int L1_open = 256;
    public static final int L1_close = 257;
    public static final int L2_open = 258;
    public static final int L2_close = 259;
    public static final int QUOTE_open = 260;
    public static final int QUOTE_close = 261;
    public static final int BOGUS_mark = 262;
    public static final int ICC_eof = 263;
    public static final int TS_BOARD_FOLLOWS = 238;
    public static final int TS_END_OF_BOARD = 237;
    public static final int TS_PING = 236;
    public static final int TS_ACK_BOARD = 235;
    public static final int TS_ACK_PING = 234;
    public static final int TS_TIMEUP = 233;
    private Thread alarm_thread;
    private long alarm_length;
    private static final long maxTimer = 3600000L;

    public IccInputStream(Iconn aconn, InputStream ain, Hub ahub, Encryptor e) {
        super(ain);
        this.connection = aconn;
        this.got_eof = false;
        this.mhub = ahub;
        this.receive_encryptor = e;
    }

    public boolean eof() {
        return this.got_eof;
    }

    private final void beep() {
        this.mhub.beep();
    }

    private final int read_byte_or_eof() throws IOException {
        int result;
        byte[] b = new byte[1];
        while (true) {
            if ((result = this.in.read()) < 0) {
                this.got_eof = true;
                return 263;
            }
            if (this.decrypting) {
                b[0] = (byte)result;
                this.receive_encryptor.encrypt_string(b, 1);
                result = b[0] & 0xFF;
            }
            if (result == 7) {
                this.beep();
                continue;
            }
            if (result != 13) break;
        }
        return result;
    }

    private final int read_datum() throws IOException {
        int result = this.read_byte_or_eof();
        if (result != 25) {
            return result;
        }
        result = this.read_byte_or_eof();
        switch (result) {
            case 91: {
                return 256;
            }
            case 93: {
                return 257;
            }
            case 40: {
                return 258;
            }
            case 41: {
                return 259;
            }
            case 123: {
                return 260;
            }
            case 125: {
                return 261;
            }
        }
        return 262;
    }

    final String read_string(boolean break_on_eol) throws IOException {
        int c;
        StringBuffer lbuf = new StringBuffer(400);
        while ((c = this.read_flat_datum()) < 256) {
            lbuf.append((char)c);
            if (!break_on_eol || c != 10) continue;
            break;
        }
        return lbuf.toString();
    }

    private final void parse_L1() throws IOException {
        try {
            String l1_value = this.read_string(false);
            if (this.connection.get_want_death()) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String read_quoted_string(int break_on) throws IOException {
        int c;
        StringBuffer lbuf = new StringBuffer(400);
        while ((c = this.read_datum()) < 256 && c != break_on) {
            lbuf.append((char)c);
        }
        return lbuf.toString();
    }

    private final void parse_L2() throws IOException {
        StringBuffer lbuf = new StringBuffer(400);
        L2Item anitem = new L2Item();
        while (true) {
            int c;
            if ((c = this.read_datum()) == 260) {
                anitem.add(this.read_quoted_string(256));
                continue;
            }
            if (c == 123) {
                anitem.add(this.read_quoted_string(125));
                continue;
            }
            if (Character.isSpace((char)c) || c >= 256) {
                if (lbuf.length() > 0) {
                    anitem.add(lbuf.toString());
                }
                lbuf.setLength(0);
                if (c < 256) continue;
                break;
            }
            lbuf.append((char)c);
        }
        if (!this.connection.get_want_death()) {
            this.mhub.receiveL2(anitem);
        }
    }

    private final void parse_quote() throws IOException {
        this.mhub.addMessage("~got a L2 quote outside of L2~\n");
    }

    private void parse_TS_ping() throws IOException {
        int c;
        StringBuffer lbuf = new StringBuffer(400);
        do {
            c = this.read_byte_or_eof();
            lbuf.append((char)c);
        } while (c != 10);
        lbuf.setLength(lbuf.length() - 1);
        this.mhub.sendCommand("\u00ea" + lbuf.toString() + "\r");
    }

    private void parse_TS_board_follows() throws IOException {
        int read_in;
        int c;
        StringBuffer lbuf = new StringBuffer();
        long myclock = 0L;
        boolean gettingclock = true;
        do {
            c = this.read_byte_or_eof();
            lbuf.append((char)c);
            if (!gettingclock || c != 10) continue;
            try {
                lbuf.setLength(lbuf.length() - 1);
                myclock = Long.parseLong(lbuf.toString());
            }
            catch (NumberFormatException e) {
                this.mhub.addMessage("~TS_boardfollows could not read clock~\n");
            }
            gettingclock = false;
            lbuf.setLength(0);
        } while (gettingclock || c != 237);
        InputStream hold = this.in;
        this.in = new StringBufferInputStream(lbuf.toString());
        this.killtimer();
        this.mhub.sendCommand("\u00eb\r");
        this.starttimer(myclock);
        this.decrypting = false;
        StringBuffer read_in_buf = new StringBuffer();
        while ((read_in = this.read_flat_datum()) != 263) {
            if (read_in >= 128) continue;
            read_in_buf.append((char)read_in);
        }
        if (read_in_buf.length() > 0) {
            this.mhub.addMessage(read_in_buf.toString());
        }
        this.decrypting = true;
        this.got_eof = false;
        this.in = hold;
    }

    public synchronized void killtimer() {
        if (this.alarm_thread != null) {
            this.alarm_thread.stop();
        }
    }

    private synchronized void starttimer(long msec) {
        if (msec > 3600000L) {
            return;
        }
        this.alarm_length = msec;
        this.alarm_thread = new Thread(this);
        try {
            this.alarm_thread.setPriority(10);
        }
        catch (SecurityException e) {
            System.out.println("Cannot use Thread.setPriority()");
        }
        this.alarm_thread.start();
    }

    public void run() {
        try {
            Thread.sleep(this.alarm_length);
            this.mhub.sendCommand("\u00e9\r");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final int read_flat_datum() throws IOException {
        int result;
        block7: while (true) {
            if (this.connection.get_want_death()) {
                return 0;
            }
            result = this.read_datum();
            switch (result) {
                case 256: {
                    this.parse_L1();
                    continue block7;
                }
                case 258: {
                    this.parse_L2();
                    continue block7;
                }
                case 260: {
                    this.parse_quote();
                    continue block7;
                }
                case 236: {
                    this.parse_TS_ping();
                    continue block7;
                }
                case 238: {
                    this.parse_TS_board_follows();
                    continue block7;
                }
            }
            break;
        }
        return result;
    }
}

