/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public final class HubLayout
implements LayoutManager {
    private int m_width = 1;
    private int m_height = 1;
    private Component gamePanel;
    private Component messagePanel;

    public void addLayoutComponent(String name, Component comp) {
        if ("GamePanel".equals(name)) {
            this.gamePanel = comp;
        } else if ("MessagePanel".equals(name)) {
            this.messagePanel = comp;
        } else {
            throw new RuntimeException("HubLayout: Unsupported component type \"" + name + "\"");
        }
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(this.m_width, this.m_height);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(this.m_width, this.m_height);
    }

    public void layoutContainer(Container parent) {
        this.m_width = parent.size().width;
        this.m_height = parent.size().height;
        if (this.gamePanel != null && this.messagePanel != null) {
            int boardLabelsWidth = 120;
            int messageHeight = this.messagePanel.minimumSize().height;
            if (this.m_width - boardLabelsWidth + messageHeight < this.m_height) {
                int y = this.m_width - boardLabelsWidth;
                this.gamePanel.reshape(0, 0, this.m_width, y);
                this.messagePanel.reshape(0, y, this.m_width, this.m_height - y);
            } else {
                this.gamePanel.reshape(0, 0, this.m_width, this.m_height - messageHeight);
                this.messagePanel.reshape(0, this.m_height - messageHeight, this.m_width, messageHeight);
            }
        }
    }
}

