/*
 * Decompiled with CFR 0.152.
 */
import java.applet.AudioClip;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;

public final class Hub
extends Panel {
    private Frame frame;
    private EasyChess applet;
    private MessagePanel messagePanel;
    private GamePanel gamePanel;
    private Iconn iconn;
    private char cPromote = (char)81;
    private boolean boolLoggedIn = false;
    public static boolean boolTimestampPossible = true;
    public boolean boolBeepOn = true;
    public boolean boolStayin211 = false;
    public String myName = "";
    private AudioClip soundBeep = null;
    private AudioClip soundBuzz = null;
    private String info = null;

    public Hub(EasyChess app) {
        this.applet = app;
        this.messagePanel = new MessagePanel(this);
        this.gamePanel = new GamePanel(this);
        this.setBackground(Config.colorBackground);
        this.setLayout(new HubLayout());
        this.add("GamePanel", this.gamePanel);
        this.add("MessagePanel", this.messagePanel);
    }

    public synchronized void sendCommand(String cmd) {
        this.iconn.send_cmd(cmd, Config.boolDebug);
    }

    public synchronized void sendCommandAndEcho(String cmd) {
        this.messagePanel.addMessage("> " + cmd);
        this.iconn.send_cmd(cmd, Config.boolDebug);
    }

    public void addMessage(String s) {
        if (this.boolLoggedIn) {
            this.messagePanel.addMessage(s);
        }
    }

    public void addChat(String s) {
        this.messagePanel.addChat(s);
    }

    public void setL2(int code, int value) {
        this.sendCommand("set-2 " + code + " " + value);
    }

    public void receiveL2(L2Item item) {
        switch (item.getCode()) {
            case 27: 
            case 50: 
            case 51: 
            case 52: {
                break;
            }
            case 28: 
            case 31: {
                this.messagePanel.receiveL2(item);
                break;
            }
            case 0: {
                this.myName = item.getString(1);
                this.frame = new EasyMenuFrame("EasyChess: " + this.myName, this);
                this.frame.setLayout(new GridLayout(1, 1));
                this.frame.add(this);
                this.frame.resize(600, 440);
                this.frame.show();
                this.boolLoggedIn = true;
                this.sendInitialSettings();
                this.messagePanel.giveFocus();
                break;
            }
            case 69: {
                this.applet.loginFailed(item.getString(2));
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 38: 
            case 39: 
            case 42: 
            case 43: {
                this.gamePanel.receiveL2(item);
                break;
            }
            default: {
                this.addMessage("Hub: Received L2 " + item.getCode());
            }
        }
    }

    public boolean handleEvent(Event evt) {
        if (this.messagePanel.handleKeypress(evt)) {
            return true;
        }
        return super.handleEvent(evt);
    }

    public void beep() {
        if (this.soundBeep != null && this.boolBeepOn) {
            this.soundBeep.play();
        }
    }

    public void buzz() {
        if (this.soundBuzz != null) {
            this.soundBuzz.play();
        }
    }

    public void setSounds(AudioClip beep, AudioClip buzz) {
        this.soundBeep = beep;
        this.soundBuzz = buzz;
    }

    public void connect() {
        this.boolLoggedIn = false;
        this.iconn = new Iconn(this, "hyper.link.cs.cmu.edu", 5000);
        while (!this.iconn.connectionEstablished()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        this.sendCommand("level2settings=1000000000000000000000000000000000000000000000000011000000000000000001");
    }

    public void login(String name, String password) {
        if (name == null || "".equals(name)) {
            this.applet.loginFailed("Please enter a name");
            return;
        }
        if ("r".equals(name)) {
            this.applet.loginFailed("This client does not support online registration");
            return;
        }
        if ("g".equals(name)) {
            password = "\n";
        } else if (name.length() < 2 || name.length() > 15) {
            this.applet.loginFailed("Choose a name between 2 and 15 characters");
            return;
        }
        if (password == null || "".equals(password)) {
            password = "\n";
        }
        this.sendCommand(String.valueOf(name) + " " + password);
    }

    public void setInfo(String s) {
        this.info = s;
    }

    public void sendInitialSettings() {
        this.sendCommand("set-quietly prompt 0");
        if (Config.boolGuest) {
            this.sendCommand("+channel 50");
            this.sendCommand("-channel 1");
            this.sendCommand("set-quietly shout 0");
            this.sendCommand("set-quietly sshout 0");
            this.sendCommand("set-quietly autoflag 1");
        }
        this.setL2(31, 1);
        this.setL2(28, 1);
        this.sendCommand("set-quietly width 200");
        this.sendCommand("set-quietly style 13");
        this.sendCommand("set-quietly highlight 0");
        this.sendCommand("set-quietly unobserve 2");
        if (this.info != null && !"".equals(this.info)) {
            this.sendCommand("set-quietly 1 " + this.info);
        }
        Toolkit tkit = this.getToolkit();
        Dimension screen_size = tkit.getScreenSize();
        int dpi = tkit.getScreenResolution();
        this.sendCommand("set-quietly interface EasyChess|0.15|" + System.getProperty("java.vendor") + "|" + System.getProperty("java.class.version") + "|" + System.getProperty("os.name") + "|" + System.getProperty("os.arch") + "|" + System.getProperty("os.version") + "|" + screen_size.width + "x" + screen_size.height + "|" + dpi);
        this.setL2(52, 1);
        this.setL2(15, 1);
        this.setL2(18, 1);
        this.setL2(16, 1);
        this.setL2(21, 1);
        this.setL2(22, 1);
        this.setL2(23, 1);
        this.setL2(34, 1);
        this.setL2(36, 1);
        this.setL2(24, 1);
        this.setL2(25, 1);
        this.setL2(38, 1);
        this.setL2(39, 1);
        this.setL2(42, 1);
        this.setL2(43, 1);
        this.setL2(27, 1);
        this.setL2(29, 1);
        this.setL2(30, 1);
    }

    public void killConnection() {
        this.addMessage("Shutting down...");
        if (this.iconn != null) {
            this.iconn.set_want_death();
        }
        this.messagePanel.shutdown();
        this.gamePanel.shutdown();
        this.applet.connected = false;
        this.applet.loginFailed("Disconnected");
        if (this.frame != null) {
            this.frame.hide();
            this.frame.dispose();
        }
    }

    public void setPromote(char c) {
        this.cPromote = c;
    }

    public char getPromote() {
        return this.cPromote;
    }

    public void visitPage(String s) {
        System.out.println("Visiting page " + s);
    }
}

