/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public final class GamePanelLayout
implements LayoutManager {
    private int m_width = 0;
    private int m_height = 0;
    private Component m_scrollbar = null;
    private Component m_board = null;
    private Component m_uppername = null;
    private Component m_lowername = null;
    private Component m_upperclock = null;
    private Component m_lowerclock = null;
    private Component m_button1 = null;
    private Component m_button2 = null;

    public GamePanelLayout(int w, int h) {
        this.m_width = w;
        this.m_height = h;
    }

    public void addLayoutComponent(String name, Component comp) {
        if ("Scrollbar".equals(name)) {
            this.m_scrollbar = comp;
        } else if ("Board".equals(name)) {
            this.m_board = comp;
        } else if ("UpperName".equals(name)) {
            this.m_uppername = comp;
        } else if ("LowerName".equals(name)) {
            this.m_lowername = comp;
        } else if ("UpperClock".equals(name)) {
            this.m_upperclock = comp;
        } else if ("LowerClock".equals(name)) {
            this.m_lowerclock = comp;
        } else if ("Button1".equals(name)) {
            this.m_button1 = comp;
        } else if ("Button2".equals(name)) {
            this.m_button2 = comp;
        } else {
            throw new RuntimeException("GamePanelLayout: Unsupported component type \"" + name + "\"");
        }
    }

    public void removeLayoutComponent(Component comp) {
        if (comp == this.m_button1) {
            this.m_button1 = null;
        } else if (comp == this.m_button2) {
            this.m_button2 = null;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(this.m_width, this.m_height);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(this.m_width, this.m_height);
    }

    public void layoutContainer(Container parent) {
        Insets insets = new Insets(2, 2, 2, 2);
        Dimension dim = null;
        int vpad = 2;
        int hpad = 2;
        this.m_width = parent.size().width;
        this.m_height = parent.size().height;
        int top = insets.top;
        int bottom = this.m_height - insets.bottom;
        if (this.m_board != null && this.m_uppername != null && this.m_lowername != null && this.m_upperclock != null && this.m_lowerclock != null) {
            int len1 = bottom - top;
            int len2 = this.m_width - insets.left - insets.right;
            len1 -= len1 % 8;
            this.m_board.reshape(insets.left, top + (bottom - top - len1) / 2, len1, len1);
            len2 = this.m_width - len1 - insets.left - insets.right - hpad;
            int left = insets.left + len1 + hpad;
            dim = this.m_uppername.preferredSize();
            this.m_uppername.reshape(left, top, len2, dim.height);
            dim = this.m_lowername.preferredSize();
            this.m_lowername.reshape(left, bottom - dim.height, len2, dim.height);
            dim = this.m_upperclock.preferredSize();
            this.m_upperclock.reshape(left, top += dim.height + vpad, len2, dim.height);
            dim = this.m_lowerclock.preferredSize();
            this.m_lowerclock.reshape(left, (bottom -= dim.height + vpad) - dim.height, len2, dim.height);
            int midline = ((top += dim.height + vpad) + (bottom -= dim.height + vpad)) / 2;
            if (this.m_button1 != null) {
                dim = this.m_button1.preferredSize();
                this.m_button1.reshape(left, midline - dim.height, len2, dim.height);
            }
            if (this.m_button2 != null) {
                dim = this.m_button2.preferredSize();
                this.m_button2.reshape(left, midline, len2, dim.height);
            }
        }
    }
}

