/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Panel;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;

public final class GamePanel
extends Panel {
    private Hub hub;
    private Board board;
    private ChessClock lowerClock;
    private ChessClock upperClock;
    private MultiLineLabel lowerName;
    private MultiLineLabel upperName;
    private ColorButton buttonDraw;
    private ColorButton buttonAccept;
    private Component button1 = null;
    private Component button2 = null;
    private boolean lowersTurn = true;
    private boolean amPlaying = false;
    private int flipVariable = 0;
    private Stack pendingMatches = new Stack();
    private Engine m_player;

    public GamePanel(Hub h) {
        this.setBackground(Config.colorGame);
        this.hub = h;
        if (!Config.boolGuest) {
            this.m_player = new Engine();
        }
        this.board = new Board(h, this);
        this.lowerClock = new ChessClock();
        this.upperClock = new ChessClock();
        this.lowerName = new MultiLineLabel(" \n ");
        this.upperName = new MultiLineLabel(" \n ");
        Font f = new Font("Helvetica", 0, 14);
        this.lowerName.setFont(f);
        this.upperName.setFont(f);
        f = new Font("Helvetica", 1, 18);
        this.lowerClock.setFont(f);
        this.upperClock.setFont(f);
        this.setLayout(new GamePanelLayout(this.size().width, this.size().height));
        this.add("Board", this.board);
        this.add("UpperClock", this.upperClock);
        this.add("UpperName", this.upperName);
        this.add("LowerName", this.lowerName);
        this.add("LowerClock", this.lowerClock);
        this.buttonDraw = new ColorButton("Draw?");
        this.buttonAccept = new ColorButton("Accept");
        this.buttonAccept.setBackground(Color.yellow);
    }

    public boolean action(Event evt, Object arg) {
        if (evt.target == this.buttonDraw) {
            this.hub.sendCommand("draw");
        }
        return true;
    }

    private void offerDraw() {
        this.buttonDraw.setLabel("DRAW?");
        this.buttonDraw.setBackground(Color.yellow);
    }

    private void rescindDraw() {
        if (this.amPlaying) {
            this.buttonDraw.setLabel("Draw?");
            this.buttonDraw.setBackground(Color.cyan);
        }
    }

    private void addMatch(String who) {
        if (who.equals(this.hub.myName)) {
            return;
        }
        this.pendingMatches.push(who);
        this.updateAcceptButton();
    }

    private void removeMatch(String who) {
        if (who.equals(this.hub.myName)) {
            return;
        }
        Enumeration enumeration = this.pendingMatches.elements();
        while (enumeration.hasMoreElements()) {
            String s = (String)enumeration.nextElement();
            if (!s.equals(who)) continue;
            this.pendingMatches.removeElement(s);
        }
        this.updateAcceptButton();
    }

    private void updateAcceptButton() {
        if (this.pendingMatches.empty()) {
            if (this.button1 == this.buttonAccept) {
                this.remove(this.buttonAccept);
                this.button1 = null;
                this.layout();
            }
        } else {
            String s = (String)this.pendingMatches.peek();
            this.buttonAccept.setLabel("Accept " + s);
            if (this.button1 != this.buttonAccept) {
                this.hub.sendCommand("accept " + s);
            }
        }
    }

    public void receiveL2(L2Item item) {
        int code = item.getCode();
        if (code != 39 && code != 42 && code != 38) {
            this.rescindDraw();
        }
        switch (code) {
            case 15: {
                this.amPlaying = true;
                this.add("Button1", this.buttonDraw);
                this.button1 = this.buttonDraw;
            }
            case 18: {
                if (this.button2 != null) {
                    this.remove(this.button2);
                    this.button2 = null;
                }
                this.layout();
                if (!Config.boolGuest) {
                    this.m_player.newGame(180000, 2000);
                }
                this.board.newGame();
                this.board.startGame();
                this.lowersTurn = true;
                this.flipVariable = 0;
                String whiteRating = item.getString(13);
                String blackRating = item.getString(14);
                String whiteTitles = item.getString(16);
                String blackTitles = item.getString(17);
                this.lowerName.setText(String.valueOf(item.getString(2)) + "\n (" + whiteRating + ") " + whiteTitles);
                this.upperName.setText(String.valueOf(item.getString(3)) + "\n (" + blackRating + ") " + blackTitles);
                this.lowerClock.setClock(item.getInt(7) * 60 * 1000);
                this.lowerClock.startClock();
                this.upperClock.setClock(item.getInt(9) * 60 * 1000);
                this.upperClock.stopClock();
                this.board.repaint();
                break;
            }
            case 39: {
                int f = item.getInt(2);
                if (f == 1) {
                    this.board.setFlipped(true);
                } else {
                    this.board.setFlipped(false);
                }
                if (f != this.flipVariable) {
                    this.flipVariable = f;
                    ChessClock.swap(this.lowerClock, this.upperClock);
                    this.lowerClock.repaint();
                    this.upperClock.repaint();
                    String hold = this.upperName.getText();
                    this.upperName.setText(this.lowerName.getText());
                    this.lowerName.setText(hold);
                    this.lowersTurn = !this.lowersTurn;
                } else if (!Config.boolGuest) {
                    MyThread hold = new MyThread();
                }
                this.repaint();
                break;
            }
            case 24: {
                int timeonclock = item.getInt(3);
                if (this.lowersTurn) {
                    this.lowerClock.stopClock();
                    this.lowerClock.setClock(timeonclock * 1000);
                    this.upperClock.startClock();
                    this.lowersTurn = false;
                    this.board.clearPending();
                    String smith = item.getString(2);
                    this.board.doSmithMove(smith);
                    if (!Config.boolGuest) {
                        Move move = new Move(smith);
                        this.m_player.applyMove(move);
                    }
                    this.board.repaint();
                    break;
                }
                this.upperClock.stopClock();
                this.upperClock.setClock(timeonclock * 1000);
                this.lowerClock.startClock();
                this.lowersTurn = true;
                if (this.amPlaying) {
                    this.hub.beep();
                }
                this.board.clearPending();
                String smith = item.getString(2);
                this.board.doSmithMove(smith);
                this.board.repaint();
                if (!Config.boolGuest) {
                    Move move = new Move(smith);
                    this.m_player.applyMove(move);
                    MyThread myThread = new MyThread();
                }
                this.board.repaint();
                break;
            }
            case 42: {
                this.board.clearPending();
                this.board.repaint();
                this.hub.buzz();
                this.hub.addMessage("Illegal move (" + item.getString(2) + ")\n");
                break;
            }
            case 38: {
                if (this.flipVariable == 0) {
                    this.lowerClock.setClock(item.getInt(2) * 1000);
                    this.upperClock.setClock(item.getInt(3) * 1000);
                    break;
                }
                this.upperClock.setClock(item.getInt(2) * 1000);
                this.lowerClock.setClock(item.getInt(3) * 1000);
                break;
            }
            case 25: {
                if (item.getSize() < 3) break;
                String s = item.getString(2);
                if (!"*".equals(s)) {
                    if (!Config.boolGuest) {
                        this.m_player.newGame(180000, 2000);
                    }
                    this.board.newGame(s);
                }
                int i = 3;
                while (i < item.getSize()) {
                    StringTokenizer st = new StringTokenizer(item.getString(i), " ");
                    this.board.doSmithMove(st.nextToken());
                    this.lowersTurn = !this.lowersTurn;
                    ++i;
                }
                this.board.repaint();
                break;
            }
            case 43: {
                break;
            }
            case 16: {
                if (this.amPlaying) {
                    this.remove(this.buttonDraw);
                    this.button1 = null;
                    this.layout();
                }
                this.amPlaying = false;
                this.lowerClock.stopClock();
                this.upperClock.stopClock();
                this.board.endGame();
                this.board.repaint();
                this.hub.addMessage("Game over: " + item.getString(5) + "\n");
                if (!this.hub.boolStayin211) break;
                this.hub.sendCommand("211");
                break;
            }
            case 21: {
                if (item.getInt(2) + item.getInt(3) > 0) {
                    this.offerDraw();
                }
                item.getInt(6);
                item.getInt(7);
                break;
            }
            case 22: 
            case 23: {
                break;
            }
            case 29: {
                this.addMatch(item.getString(1));
                break;
            }
            case 30: {
                this.removeMatch(item.getString(1));
                break;
            }
            default: {
                this.hub.addMessage("Error in GamePanel: Received L2 " + item.getCode() + "\n");
            }
        }
    }

    public Dimension preferredSize() {
        return new Dimension(1, 1);
    }

    public void shutdown() {
        this.lowerClock.stopClock();
        this.upperClock.stopClock();
        this.lowerClock.setClock(180000L);
        this.upperClock.setClock(180000L);
        this.lowerName.setText(" \n ");
        this.upperName.setText(" \n ");
        this.amPlaying = false;
        this.lowersTurn = true;
        this.flipVariable = 0;
        if (this.button1 != null) {
            this.remove(this.button1);
        }
        if (this.button2 != null) {
            this.remove(this.button2);
        }
        if (!Config.boolGuest) {
            this.m_player.newGame(180000, 2000);
        }
        this.board.newGame();
        this.pendingMatches.removeAllElements();
    }

    private class MyThread
    implements Runnable {
        Thread t = new Thread(this);

        MyThread() {
            this.t.setPriority(10);
            this.t.start();
        }

        public void run() {
            try {
                Move ur_move = GamePanel.this.m_player.computeMove((int)((GamePanel)GamePanel.this).lowerClock.msecleft, (int)((GamePanel)GamePanel.this).upperClock.msecleft);
                if (ur_move != null && GamePanel.this.amPlaying) {
                    GamePanel.this.hub.sendCommand(ur_move.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

