/*
 * Decompiled with CFR 0.152.
 */
import java.awt.CheckboxMenuItem;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;

public class EasyMenuFrame
extends Frame {
    private Hub hub;
    private MenuBar mb;
    private MenuItem fileExit;
    private MenuItem infoFinger;
    private MenuItem infoPing;
    private MenuItem gameDraw;
    private MenuItem gameAbort;
    private MenuItem gameResign;
    private CheckboxMenuItem promoteQueen;
    private CheckboxMenuItem promoteRook;
    private CheckboxMenuItem promoteKnight;
    private CheckboxMenuItem promoteBishop;
    private CheckboxMenuItem stayin211pool;
    private CheckboxMenuItem optionsBell;
    private MenuItem optionsRefresh;
    private MenuItem helpAbout;

    public EasyMenuFrame(String title, Hub hub) {
        super(title);
        this.hub = hub;
        this.mb = new MenuBar();
        this.initFile();
        this.initInfo();
        this.initGame();
        this.initOptions();
        this.initHelp();
        this.setMenuBar(this.mb);
    }

    private void initFile() {
        Menu m = new Menu("File");
        this.fileExit = new MenuItem("Exit");
        m.add(this.fileExit);
        this.mb.add(m);
    }

    private void initInfo() {
        Menu m = new Menu("Info");
        this.infoFinger = new MenuItem("Show personal stats");
        m.add(this.infoFinger);
        this.infoPing = new MenuItem("Show internet lag");
        m.add(this.infoPing);
        this.mb.add(m);
    }

    private void initGame() {
        Menu m = new Menu("Game");
        this.gameDraw = new MenuItem("Suggest a draw");
        m.add(this.gameDraw);
        this.gameAbort = new MenuItem("Suggest an abort");
        m.add(this.gameAbort);
        this.gameResign = new MenuItem("Resign");
        m.add(this.gameResign);
        m.addSeparator();
        this.promoteQueen = new CheckboxMenuItem("Promote to queen");
        this.promoteQueen.setState(true);
        m.add(this.promoteQueen);
        this.promoteRook = new CheckboxMenuItem("Promote to rook");
        m.add(this.promoteRook);
        this.promoteKnight = new CheckboxMenuItem("Promote to knight");
        m.add(this.promoteKnight);
        this.promoteBishop = new CheckboxMenuItem("Promote to bishop");
        m.add(this.promoteBishop);
        m.addSeparator();
        this.stayin211pool = new CheckboxMenuItem("Stay in the 211 pool");
        this.stayin211pool.setState(this.hub.boolStayin211);
        m.add(this.stayin211pool);
        this.mb.add(m);
    }

    private void initOptions() {
        Menu m = new Menu("Options");
        this.optionsBell = new CheckboxMenuItem("Bell");
        this.optionsBell.setState(this.hub.boolBeepOn);
        m.add(this.optionsBell);
        this.optionsRefresh = new MenuItem("Repaint window");
        m.add(this.optionsRefresh);
        this.mb.add(m);
    }

    private void initHelp() {
        Menu m = new Menu("Help");
        this.helpAbout = new MenuItem("About...");
        m.add(this.helpAbout);
        this.mb.add(m);
    }

    public boolean action(Event evt, Object arg) {
        if (evt.target == this.promoteQueen) {
            this.hub.setPromote('q');
            this.promoteQueen.setState(true);
            this.promoteRook.setState(false);
            this.promoteBishop.setState(false);
            this.promoteKnight.setState(false);
        } else if (evt.target == this.promoteRook) {
            this.hub.setPromote('r');
            this.promoteQueen.setState(false);
            this.promoteRook.setState(true);
            this.promoteBishop.setState(false);
            this.promoteKnight.setState(false);
        } else if (evt.target == this.promoteBishop) {
            this.hub.setPromote('b');
            this.promoteQueen.setState(false);
            this.promoteRook.setState(false);
            this.promoteBishop.setState(true);
            this.promoteKnight.setState(false);
        } else if (evt.target == this.promoteKnight) {
            this.hub.setPromote('n');
            this.promoteQueen.setState(false);
            this.promoteRook.setState(false);
            this.promoteBishop.setState(false);
            this.promoteKnight.setState(true);
        } else if (evt.target == this.infoFinger) {
            this.hub.sendCommand("finger");
        } else if (evt.target == this.infoPing) {
            this.hub.sendCommand("multi lagstat; ping");
        } else if (evt.target == this.gameDraw) {
            this.hub.sendCommand("draw");
        } else if (evt.target == this.gameAbort) {
            this.hub.sendCommand("abort");
        } else if (evt.target == this.gameResign) {
            this.hub.sendCommand("resign");
        } else if (evt.target == this.stayin211pool) {
            boolean b = !this.hub.boolStayin211;
            this.stayin211pool.setState(b);
            this.hub.boolStayin211 = b;
        } else if (evt.target == this.optionsBell) {
            boolean b = !this.hub.boolBeepOn;
            this.optionsBell.setState(b);
            this.hub.boolBeepOn = b;
        } else if (evt.target == this.optionsRefresh) {
            this.hub.repaint();
        } else if (evt.target == this.fileExit) {
            this.hub.sendCommand("exit");
        } else if (evt.target == this.helpAbout) {
            this.hub.visitPage("http://www-2.cs.cmu.edu/afs/cs.cmu.edu/academic/class/15211-f04/www/hw6/");
        } else {
            return false;
        }
        return true;
    }
}

