/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public final class ColorButton
extends Canvas {
    protected String text;
    protected int line_height;
    protected int line_ascent;
    protected int line_width;
    protected int margin_width = 4;
    protected int margin_height = 2;
    private boolean depressed = false;
    private boolean buttondown = false;
    public static final char CENTER = '\u0000';
    public static final char TOP = '\u0001';
    public static final char BOTTOM = '\u0002';
    public static final char LEFT = '\u0003';
    public static final char RIGHT = '\u0004';
    private char justification = '\u0000';

    public ColorButton() {
        this.text = "";
    }

    public ColorButton(String s) {
        this.text = s;
    }

    public void setLabel(String s) {
        this.text = s;
        this.measure();
        this.repaint();
    }

    public String getLabel() {
        return this.text;
    }

    public void setAlignment(char a) {
        this.justification = a;
    }

    public char getAlignment() {
        return this.justification;
    }

    protected void measure() {
        Font f = this.getFont();
        if (f == null) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(f);
        if (fm == null) {
            return;
        }
        this.line_height = fm.getHeight();
        this.line_ascent = fm.getAscent();
        this.line_width = fm.stringWidth(this.text);
    }

    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    public Dimension preferredSize() {
        return new Dimension(this.line_width + 2 * this.margin_width, this.line_height + 2 * this.margin_height);
    }

    public Dimension minimumSize() {
        return new Dimension(this.line_width + 2, this.line_height + 2);
    }

    public void paint(Graphics g) {
        int x;
        int y;
        Dimension d = this.size();
        switch (this.justification) {
            case '\u0001': {
                y = this.line_ascent + this.margin_height;
                x = (d.width - this.line_width) / 2;
                break;
            }
            case '\u0002': {
                y = d.height - this.margin_height;
                x = (d.width - this.line_width) / 2;
                break;
            }
            case '\u0003': {
                y = this.line_ascent + (d.height - this.line_height) / 2;
                x = this.margin_width;
                break;
            }
            case '\u0004': {
                y = this.line_ascent + (d.height - this.line_height) / 2;
                x = d.width - this.line_width - this.margin_width;
                break;
            }
            default: {
                y = this.line_ascent + (d.height - this.line_height) / 2;
                x = (d.width - this.line_width) / 2;
            }
        }
        if (this.depressed) {
            ++x;
            ++y;
        }
        g.drawString(this.text, x, y);
        g.setColor(this.depressed ? Color.black : Color.white);
        g.drawLine(0, 0, d.width, 0);
        g.drawLine(0, 0, 0, d.height);
        g.setColor(this.depressed ? Color.white : Color.black);
        g.drawLine(0, d.height - 1, d.width, d.height - 1);
        g.drawLine(d.width - 1, 0, d.width - 1, d.height);
    }

    public boolean mouseUp(Event evt, int x, int y) {
        if (this.depressed) {
            this.postEvent(new Event(this, 1001, this.text));
            this.depressed = false;
            this.repaint();
        }
        this.buttondown = false;
        return true;
    }

    public boolean mouseDown(Event evt, int x, int y) {
        this.depressed = true;
        this.buttondown = true;
        this.repaint();
        return true;
    }

    public boolean mouseEnter(Event evt, int x, int y) {
        if (this.buttondown) {
            this.depressed = true;
            this.repaint();
        }
        return true;
    }

    public boolean mouseExit(Event evt, int x, int y) {
        if (this.buttondown) {
            this.depressed = false;
            this.repaint();
        }
        return true;
    }
}

