/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;

public final class ChessClock
extends Canvas
implements Runnable {
    private static Font font;
    private boolean running = false;
    long msecleft = 0L;
    private long referencetime;
    private long referencetimeleft;
    private Thread runner = null;
    private static Color colorHighlight;
    private static Color colorIdle;

    static {
        colorHighlight = Config.colorClockRunning;
        colorIdle = Config.colorClockIdle;
    }

    public ChessClock() {
        this.setFont(font);
        this.setForeground(colorIdle);
        this.runner = new Thread(this);
        this.runner.start();
        this.stopClock();
        this.setClock(180000L);
    }

    public static void swap(ChessClock a, ChessClock b) {
        boolean r = a.running;
        long l1 = a.msecleft;
        long l2 = a.referencetime;
        long l3 = a.referencetimeleft;
        a.running = b.running;
        a.msecleft = b.msecleft;
        a.referencetime = b.referencetime;
        a.referencetimeleft = b.referencetimeleft;
        b.running = r;
        b.msecleft = l1;
        b.referencetime = l2;
        b.referencetimeleft = l3;
    }

    public void killClock() {
        this.runner.stop();
    }

    public void stopClock() {
        this.running = false;
        this.repaint();
    }

    public void startClock() {
        this.setClock(this.msecleft);
        this.running = true;
        this.runner.interrupt();
    }

    public void setClock(long l) {
        this.msecleft = l;
        this.referencetimeleft = l;
        this.referencetime = System.currentTimeMillis();
        this.repaint();
    }

    public void run() {
        while (true) {
            try {
                if (this.running) {
                    this.msecleft = this.referencetimeleft - System.currentTimeMillis() + this.referencetime;
                    this.repaint();
                }
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void paint(Graphics g) {
        int timeleft = (int)(this.msecleft / 1000L);
        int min = Math.abs(timeleft / 60);
        int sec = timeleft > 0 ? timeleft % 60 : -timeleft % 60;
        String s = timeleft < 0 ? "-" + min + ":" : min + ":";
        s = sec < 10 ? String.valueOf(s) + "0" + sec : String.valueOf(s) + sec;
        if (this.running) {
            g.setColor(colorHighlight);
        }
        g.drawString(s, 2, 16);
    }

    public Dimension minimumSize() {
        return new Dimension(60, 16);
    }

    public Dimension preferredSize() {
        return new Dimension(60, 16);
    }
}

