/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

public final class Board
extends Canvas {
    private Hub hub;
    private GamePanel gamePanel;
    private Color colorDarkSquare = Config.colorDarkSquareIdle;
    private Color colorLightSquare = Config.colorLightSquareIdle;
    private Color colorHighlight = Config.colorHighlight;
    private boolean isFlipped = false;
    private char[][] pieces;
    private final String initialPosition = "rnbqkbnrpppppppp--------------------------------PPPPPPPPRNBQKBNR";
    private int squareSize = 1;
    private Point highlit1 = null;
    private Point highlit2 = null;
    private boolean playing = false;
    private Painter painter;
    private boolean isPending = false;
    private Point pendingFrom = null;
    private Point pendingTo = null;
    Image offscreen = null;
    Graphics offscreeng = null;
    int offwidth = 0;
    int offheight = 0;
    private boolean shortCastleOK;
    private boolean longCastleOK;
    private int enPassantFile;
    private Point mouseFrom = null;
    private Point mouseTo = null;

    public Board(Hub h, GamePanel g) {
        this.hub = h;
        this.gamePanel = g;
        this.pieces = new char[8][8];
        this.painter = new Painter();
        this.newGame();
    }

    public void repaint() {
        int w = this.size().width;
        int h = this.size().height;
        if (this.offscreen == null || w != this.offwidth || h != this.offheight) {
            this.offscreen = this.createImage(w, h);
            this.offscreeng = this.offscreen.getGraphics();
            this.offwidth = w;
            this.offheight = h;
        }
        this.update(this.offscreeng);
        this.getGraphics().drawImage(this.offscreen, 0, 0, this);
    }

    public void startGame() {
        this.playing = true;
        this.colorDarkSquare = Config.colorDarkSquareActive;
        this.colorLightSquare = Config.colorLightSquareActive;
        this.setHighlights(null);
    }

    public void endGame() {
        this.playing = false;
        this.colorDarkSquare = Config.colorDarkSquareIdle;
        this.colorLightSquare = Config.colorLightSquareIdle;
    }

    public void newGame() {
        this.resetStateVariables();
        int row = 0;
        while (row < 8) {
            int col = 0;
            while (col < 8) {
                this.pieces[row][col] = "rnbqkbnrpppppppp--------------------------------PPPPPPPPRNBQKBNR".charAt(row * 8 + col);
                ++col;
            }
            ++row;
        }
    }

    public void newGame(String initial) {
        this.resetStateVariables();
        if ("*".equals(initial)) {
            initial = "rnbqkbnrpppppppp--------------------------------PPPPPPPPRNBQKBNR";
        }
        int row = 0;
        while (row < 8) {
            int col = 0;
            while (col < 8) {
                this.pieces[row][col] = initial.charAt(row * 8 + col);
                ++col;
            }
            ++row;
        }
    }

    public void setFlipped(boolean b) {
        if (this.isFlipped != b) {
            this.isFlipped = b;
            if (this.highlit1 != null) {
                this.highlit1 = new Point(7 - this.highlit1.x, 7 - this.highlit1.y);
            }
            if (this.highlit2 != null) {
                this.highlit2 = new Point(7 - this.highlit2.x, 7 - this.highlit2.y);
            }
        }
    }

    public void paint(Graphics g) {
        int col;
        this.squareSize = this.size().width;
        if (this.size().height < this.squareSize) {
            this.squareSize = this.size().height;
        }
        this.squareSize /= 8;
        g.setColor(this.colorLightSquare);
        int row = 0;
        while (row < 8) {
            col = row % 2;
            while (col < 8) {
                g.fillRect(col * this.squareSize, row * this.squareSize, this.squareSize, this.squareSize);
                col += 2;
            }
            ++row;
        }
        g.setColor(this.colorDarkSquare);
        row = 0;
        while (row < 8) {
            col = (row + 1) % 2;
            while (col < 8) {
                g.fillRect(col * this.squareSize, row * this.squareSize, this.squareSize, this.squareSize);
                col += 2;
            }
            ++row;
        }
        row = 0;
        while (row < 8) {
            col = 0;
            while (col < 8) {
                this.painter.drawPiece(g, this.getPiece(col, row), this.squareSize, col * this.squareSize, row * this.squareSize);
                ++col;
            }
            ++row;
        }
        if (this.isPending) {
            if ((this.pendingFrom.x + this.pendingFrom.y) % 2 == 0) {
                g.setColor(this.colorLightSquare);
            } else {
                g.setColor(this.colorDarkSquare);
            }
            g.fillRect(this.pendingFrom.x * this.squareSize, this.pendingFrom.y * this.squareSize, this.squareSize, this.squareSize);
            if (this.getPiece(this.pendingTo) != '-') {
                if ((this.pendingTo.x + this.pendingTo.y) % 2 == 0) {
                    g.setColor(this.colorLightSquare);
                } else {
                    g.setColor(this.colorDarkSquare);
                }
                g.fillRect(this.pendingTo.x * this.squareSize, this.pendingTo.y * this.squareSize, this.squareSize, this.squareSize);
            }
            this.painter.drawPiece(g, this.getPiece(this.pendingFrom), this.squareSize, this.pendingTo.x * this.squareSize, this.pendingTo.y * this.squareSize);
        }
        g.setColor(this.colorHighlight);
        if (this.highlit1 != null) {
            g.drawRect(this.highlit1.x * this.squareSize, this.highlit1.y * this.squareSize, this.squareSize - 1, this.squareSize - 1);
        }
        if (this.highlit2 != null) {
            g.drawRect(this.highlit2.x * this.squareSize, this.highlit2.y * this.squareSize, this.squareSize - 1, this.squareSize - 1);
        }
    }

    public char getPiece(int col, int row) {
        if (this.isFlipped) {
            return this.pieces[7 - row][7 - col];
        }
        return this.pieces[row][col];
    }

    public char getPiece(Point p) {
        return this.getPiece(p.x, p.y);
    }

    public void setPiece(int col, int row, char p) {
        if (this.isFlipped) {
            this.pieces[7 - row][7 - col] = p;
        } else {
            this.pieces[row][col] = p;
        }
    }

    public void setPiece(Point pt, char pc) {
        this.setPiece(pt.x, pt.y, pc);
    }

    private void resetStateVariables() {
        this.shortCastleOK = true;
        this.longCastleOK = true;
        this.enPassantFile = -1;
        this.isFlipped = false;
        this.highlit1 = null;
        this.highlit2 = null;
    }

    private void setStateVariables(String smith) {
        String algFrom = smith.substring(0, 2);
        Point bdFrom = this.algebraicToBoard(algFrom);
        String algTo = smith.substring(2, 4);
        Point bdTo = this.algebraicToBoard(algTo);
        char piece = this.getPiece(bdFrom);
        this.enPassantFile = -1;
        if (!this.isFlipped) {
            if (piece == 'p' && bdFrom.y == 1 && bdTo.y == 3) {
                this.enPassantFile = bdTo.x;
            }
            if (piece == 'K') {
                this.shortCastleOK = false;
                this.longCastleOK = false;
            }
            if (piece == 'R') {
                if ("a1".equals(algFrom)) {
                    this.longCastleOK = false;
                }
                if ("h1".equals(algFrom)) {
                    this.shortCastleOK = false;
                }
            }
        } else {
            if (piece == 'P' && bdFrom.y == 1 && bdTo.y == 3) {
                this.enPassantFile = bdTo.x;
            }
            if (piece == 'k') {
                this.shortCastleOK = false;
                this.longCastleOK = false;
            }
            if (piece == 'r') {
                if ("a8".equals(algFrom)) {
                    this.longCastleOK = false;
                }
                if ("h8".equals(algFrom)) {
                    this.shortCastleOK = false;
                }
            }
        }
    }

    public boolean isLegalMove(Point bdFrom, Point bdTo) {
        int absdy;
        char piece = this.getPiece(bdFrom);
        boolean white = Board.isWhite(piece);
        int dx = bdTo.x - bdFrom.x;
        int dy = bdTo.y - bdFrom.y;
        int absdx = dx > 0 ? dx : -dx;
        int n = absdy = dy > 0 ? dy : -dy;
        if (white == this.isFlipped) {
            return false;
        }
        char captured = this.getPiece(bdTo);
        if (captured != '-' && white == Board.isWhite(captured)) {
            return false;
        }
        piece = Character.toLowerCase(piece);
        switch (piece) {
            case '-': {
                return false;
            }
            case 'n': {
                return absdx == 2 && absdy == 1 || absdx == 1 && absdy == 2;
            }
            case 'r': {
                if (dx != 0 && dy != 0) {
                    return false;
                }
                return this.clearPath(bdFrom, bdTo);
            }
            case 'b': {
                if (absdx != absdy) {
                    return false;
                }
                return this.clearPath(bdFrom, bdTo);
            }
            case 'q': {
                if (dx == 0 || dy == 0 || absdx == absdy) {
                    return this.clearPath(bdFrom, bdTo);
                }
                return false;
            }
            case 'k': {
                if (absdx <= 1 && absdy <= 1) {
                    return true;
                }
                if (absdx == 2 && dy == 0 && bdFrom.y == 7) {
                    if (!this.isFlipped) {
                        if (bdFrom.x != 4) {
                            return false;
                        }
                        if (dx == -2) {
                            return this.longCastleOK && this.getPiece(0, 7) == 'R' && this.clearPath(bdFrom, new Point(1, 7));
                        }
                        return this.shortCastleOK && this.getPiece(7, 7) == 'R' && this.clearPath(bdFrom, bdTo);
                    }
                    if (bdFrom.x != 3) {
                        return false;
                    }
                    if (dx == -2) {
                        return this.shortCastleOK && this.getPiece(0, 7) == 'r' && this.clearPath(bdFrom, bdTo);
                    }
                    return this.longCastleOK && this.getPiece(7, 7) == 'r' && this.clearPath(bdFrom, new Point(6, 7));
                }
                return false;
            }
            case 'p': {
                if (dx == 0 && dy == -1) {
                    return captured == '-';
                }
                if (dx == 0 && dy == -2 && bdFrom.y == 6) {
                    return this.clearPath(bdFrom, bdTo);
                }
                if (absdx == 1 && dy == -1) {
                    captured = this.getPiece(bdTo);
                    if (captured != '-') {
                        return true;
                    }
                    if (bdFrom.y != 3) {
                        return false;
                    }
                    if (this.enPassantFile != bdTo.x) {
                        return false;
                    }
                    captured = this.getPiece(bdTo.x, bdFrom.y);
                    if (white == Board.isWhite(captured)) {
                        return false;
                    }
                    if (captured == 'p' || captured == 'P') {
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    private boolean clearPath(Point from, Point to) {
        int dx = this.signum(to.x - from.x);
        int dy = this.signum(to.y - from.y);
        int x = from.x + dx;
        int y = from.y + dy;
        while (x != to.x || y != to.y) {
            if (this.getPiece(x, y) != '-') {
                return false;
            }
            x += dx;
            y += dy;
        }
        return true;
    }

    private int signum(int n) {
        return n == 0 ? 0 : (n > 0 ? 1 : -1);
    }

    public void setHighlights(String smith) {
        if (smith == null) {
            this.highlit1 = null;
            this.highlit2 = null;
            return;
        }
        this.highlit1 = this.algebraicToBoard(smith.substring(0, 2));
        this.highlit2 = this.algebraicToBoard(smith.substring(2, 4));
    }

    public void setHighlights(Point bd1, Point bd2) {
        this.highlit1 = bd1;
        this.highlit2 = bd2;
    }

    public Point algebraicToBoard(String s) {
        char c1 = s.charAt(0);
        char c2 = s.charAt(1);
        if (this.isFlipped) {
            return new Point(7 - (c1 - 97), c2 - 49);
        }
        return new Point(c1 - 97, 7 - (c2 - 49));
    }

    public String boardToAlgebraic(Point p) {
        char[] s = new char[2];
        if (this.isFlipped) {
            s[0] = (char)(104 - p.x);
            s[1] = (char)(49 + p.y);
        } else {
            s[0] = (char)(97 + p.x);
            s[1] = (char)(56 - p.y);
        }
        return new String(s);
    }

    public Point screenToBoard(int x, int y) {
        return new Point(x / this.squareSize, y / this.squareSize);
    }

    public Point screenToBoard(Point p) {
        return this.screenToBoard(p.x, p.y);
    }

    public String screenToAlgebraic(int x, int y) {
        return this.boardToAlgebraic(this.screenToBoard(x, y));
    }

    public String screenToAlgebraic(Point p) {
        return this.screenToAlgebraic(p.x, p.y);
    }

    public void setPending(Point p1, Point p2) {
        this.isPending = true;
        this.pendingFrom = p1;
        this.pendingTo = p2;
    }

    public void clearPending() {
        this.isPending = false;
    }

    public boolean mouseDown(Event evt, int x, int y) {
        if (Config.boolGuest) {
            if (!this.playing) {
                return true;
            }
            this.mouseTo = null;
            if (x < 8 * this.squareSize && y < 8 * this.squareSize) {
                this.mouseFrom = this.screenToBoard(x, y);
                if (this.getPiece(this.mouseFrom) == '-') {
                    this.mouseFrom = null;
                    return true;
                }
                this.highlit1 = this.mouseFrom;
                this.highlit2 = null;
            } else {
                this.mouseFrom = null;
            }
        }
        return true;
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        if (Config.boolGuest) {
            if (!this.playing || this.mouseFrom == null) {
                return true;
            }
            if (x < 0 || y < 0 || x >= 8 * this.squareSize || y >= 8 * this.squareSize) {
                return true;
            }
            Point p2 = this.screenToBoard(x, y);
            if (!p2.equals(this.mouseTo)) {
                this.mouseTo = p2;
                this.colorHighlight = this.isLegalMove(this.mouseFrom, this.mouseTo) ? Config.colorLegalMove : Config.colorIllegalMove;
                this.highlit2 = this.mouseTo;
            }
            this.repaint();
        }
        return true;
    }

    public boolean mouseUp(Event evt, int x, int y) {
        if (Config.boolGuest) {
            if (!this.playing || this.mouseFrom == null) {
                return true;
            }
            this.setHighlights(null);
            if (x < 8 * this.squareSize && y < 8 * this.squareSize) {
                String algTo;
                String algFrom = this.boardToAlgebraic(this.mouseFrom);
                if (algFrom.equals(algTo = this.screenToAlgebraic(x, y))) {
                    this.mouseFrom = null;
                } else {
                    Point p1 = this.mouseFrom;
                    Point p2 = this.screenToBoard(x, y);
                    if (!this.isLegalMove(p1, p2)) {
                        this.hub.buzz();
                        this.repaint();
                        this.mouseFrom = null;
                        return true;
                    }
                    this.setPending(p1, p2);
                    this.setHighlights(p1, p2);
                    if ((p2.y == 0 || p2.y == 7) && Character.toUpperCase(this.getPiece(p1)) == 'P') {
                        this.hub.sendCommand(String.valueOf(algFrom) + algTo + '=' + this.hub.getPromote());
                    } else {
                        this.hub.sendCommand(String.valueOf(algFrom) + algTo);
                    }
                }
            }
            this.repaint();
        }
        return true;
    }

    public void doSmithMove(String smith) {
        int len = smith.length();
        if (len < 4) {
            return;
        }
        this.setHighlights(smith);
        this.setStateVariables(smith);
        Point from = this.algebraicToBoard(smith.substring(0, 2));
        Point to = this.algebraicToBoard(smith.substring(2, 4));
        char piece = this.getPiece(from);
        char end = smith.charAt(len - 1);
        if (len == 4 || "pnbrqk".indexOf(end) != -1) {
            this.setPiece(from, '-');
            this.setPiece(to, piece);
            return;
        }
        if ("QNBR".indexOf(end) != -1) {
            piece = Character.isUpperCase(piece) ? end : Character.toLowerCase(end);
            this.setPiece(from, '-');
            this.setPiece(to, piece);
            return;
        }
        if (end == 'c') {
            this.setPiece(from, '-');
            this.setPiece(to, piece);
            if (from.x == 3) {
                piece = this.getPiece(0, from.y);
                this.setPiece(0, from.y, '-');
                this.setPiece(2, from.y, piece);
            } else {
                piece = this.getPiece(7, from.y);
                this.setPiece(7, from.y, '-');
                this.setPiece(5, from.y, piece);
            }
            return;
        }
        if (end == 'C') {
            this.setPiece(from, '-');
            this.setPiece(to, piece);
            if (from.x == 4) {
                piece = this.getPiece(0, from.y);
                this.setPiece(0, from.y, '-');
                this.setPiece(3, from.y, piece);
            } else {
                piece = this.getPiece(7, from.y);
                this.setPiece(7, from.y, '-');
                this.setPiece(4, from.y, piece);
            }
            return;
        }
        if (end == 'E') {
            this.setPiece(from, '-');
            this.setPiece(to, piece);
            this.setPiece(to.x, from.y, '-');
            return;
        }
        System.out.println("bogus smith move: " + smith);
    }

    public static boolean isWhite(char piece) {
        return Character.isUpperCase(piece);
    }

    public static boolean isBlack(char piece) {
        return Character.isLowerCase(piece);
    }

    public Dimension preferredSize() {
        return new Dimension(128, 128);
    }

    public Dimension minimumSize() {
        return new Dimension(80, 80);
    }
}

