import java.util.*;

public class Engine {

    private ChessBoard board;  //   The current board state

    /* Timing information.  All times are in milliseconds.  */
    private long startTime;  //  the time in milliseconds when we started thinking
    private long allocated;  //  the amount of time we allocated to think about this move
    private int initialTime, increment;  // The time control

    /* Some constants that may be useful */
    private static final int WHITE = ChessBoard.WHITE;
    private static final int BLACK = ChessBoard.BLACK;
    private static final int INFINITY=1000000, MATE = 300000;

    /* The name of your program */
    private static final String programName = "Put Your Name Here";

    /* Here are the public methods for Player.  You may change these
       methods, but do not alter their signatures.  There's probably
       no reason to change these unless you rewrite ChessBoard.
    */

    public String getName() {
	return programName;
    }

    public void newGame(int time, int inc) {
	initialTime = time;
	increment = inc;
	board = new ChessBoard();
    }

    /* Apply a move */
    public void applyMove(Move m) {
	board.makeMove(m);
    }

    /* Return the player's board state */
    public ChessBoard getBoard() {
	return board;
    }

    /** Compute and return a move in the current position.
	Currently, it just
    */
    public Move computeMove(int timeleft, int optime) {

	Move move;

	startTime = System.currentTimeMillis();
	allocated = allocateTime(timeleft, optime);
	System.out.println("ALLOCATED: " + allocated + "ms");

	return search();
    }

    /* -------------------------------------------------------------
       Completed Private Methods Feel free to change these, if you
       want, but it's not necessary.
       -------------------------------------------------------------*/

    /** This method computes and returns an amount of time to allocate
	to the current move.  It takes as parameters my time left, and
	the opponent's time left.  However this implementation only
	makes use of my time left, and the increment (increment).
        All times are in milliseconds. 
     
	The way it computes this is that it assumes the game is going
        to last 30 more moves, so it allocates 1/30th of the remaining
	time, plus the increment, to the current move.
    */
    private int allocateTime(int timeleft, int optime) {
	double t = increment + timeleft/30.0;
	if (t > timeleft) t = .9*timeleft;
	return (int) t;
    }


    /** Am I out of thinking time?

	The idea is that this is called in the middle of the loop
	that tries out all moves in the alpha_beta search.  When it
	returns true, the search is aborted.
	
	The variable earlyAbort could be used to communicate up the
	call stack that this happened.  The variable noTimeup could be
	used to turn off this mechanism, for example, if you wanted to
	make sure that at least a full 1-ply search is completed
	without interruption.
    */
    private boolean timeup() {
    //	if (noTimeup) return false;
	if ((System.currentTimeMillis()-startTime) > allocated) {
	// earlyAbort = true;  
	    return true;
	}
	return false;
    }


    /* -------------------------------------------------------------
       Private methods to complete.  The following methods are
       incomplete.  The comments give some hint about what I'm
       thinking they should do.  Feel free to use them or not.
       -------------------------------------------------------------*/


    /* This could, for example, try alpha_beta at depths 1, 2, 3, ...
       until we get a timeup().  At which point it returns the best
       move it found by the deepest completed search.   Right now it
       makes a random move.
    */
    private Move search() {
	return randomMove();
    }

    private Move randomMove() {
	/* If there is at least one capture move, choose one of them at random,
	   otherwise just move randomly. */
	Random rand = new Random();
	List moveList = board.generateMoves();
	if (moveList.size() == 0) return null;  // if the game is over, just return null

	Move [] moveArray = (Move[]) moveList.toArray(new Move[0]);
	Move [] captureArray = new Move[moveArray.length];
	int capCount = 0;
	for (int i=0; i<moveArray.length; i++) if (moveArray[i].capture) captureArray[capCount++] = moveArray[i];
	if (capCount > 0) return captureArray[rand.nextInt(capCount)];
	return moveArray[rand.nextInt(moveArray.length)];
    }


    /* Implement alpha beta search here.  You'll probably want to
       modify the parameters and/or return values.  Some way is needed
       to have it send back to the caller (at least at top level)
       which move was the best.  Also, it may be useful for it to know
       if this is a toplevel call (i.e. from search()) for example,
       because if there was just one legal move, then it could return
       without waiting to actually compute a score for that position.
       This is not true lower down in the tree.
    */
    private int alpha_beta(ChessBoard board, int depth, int alpha, int beta) {
	return 0;
    }
}
